/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.util.ArrayList;
import scimat.gui.commands.edit.add.AddWordsToWordGroupEdit;
import scimat.gui.commands.edit.delete.DeleteWordEdit;
import scimat.gui.commands.edit.delete.DeleteWordGroupEdit;
import scimat.gui.commands.edit.delete.DeleteWordsFromWordGroupEdit;
import scimat.gui.commands.edit.move.MoveWordToDifferentWordGroupEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.itemslist.WordGroupsListPanel;
import scimat.gui.components.itemslist.WordsWithoutGroupListPanel;
import scimat.gui.components.joindialog.JoinEntitiesDialogManager;
import scimat.gui.components.manager.GenericManualSetGroupPanel;
import scimat.gui.components.movetogroup.MoveToGroupDialogManager;
import scimat.gui.components.slavepanel.WordGroupSlaveWordsPanel;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordGroupManualSetManager
extends GenericManualSetGroupPanel<WordGroup, Word> {
    public WordGroupManualSetManager() {
        super(new WordGroupsListPanel(), new WordsWithoutGroupListPanel(), new WordGroupSlaveWordsPanel());
        this.setDescription("Word groups", "Words of the group", "Words without group");
    }

    @Override
    public void addGroupAction() {
        AddDialogManager.getInstance().showAddWordGroupDialog();
    }

    @Override
    public void editGroupAction(WordGroup group) {
        EditDialogManager.getInstance().showEditWordGroupDialog(group);
    }

    @Override
    public void moveGroupToAction(ArrayList<WordGroup> groups) {
        JoinEntitiesDialogManager.getInstance().showWordGroupsJoinDialog(groups);
    }

    @Override
    public void deleteGroupAction(ArrayList<WordGroup> groups) {
        new PerformKnowledgeBaseEditTask(new DeleteWordGroupEdit(groups), this).execute();
    }

    @Override
    public void toNewGroupAction(ArrayList<Word> itemsWithoutGroup) {
        MoveToGroupDialogManager.getInstance().showMoveWordsToNewGroupDialog(itemsWithoutGroup);
    }

    @Override
    public void toDifferentGroupAction(ArrayList<Word> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new MoveWordToDifferentWordGroupEdit(itemsWithoutGroup), this).execute();
    }

    @Override
    public void removeItemFromGroupAction(ArrayList<Word> itemsFromGroup, WordGroup group) {
        new PerformKnowledgeBaseEditTask(new DeleteWordsFromWordGroupEdit(itemsFromGroup, group), this).execute();
    }

    @Override
    public void addItemToGroupAction(WordGroup group, ArrayList<Word> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new AddWordsToWordGroupEdit(itemsWithoutGroup, group), this).execute();
    }

    @Override
    public void removeItemsWithoutGroup(ArrayList<Word> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new DeleteWordEdit(itemsWithoutGroup), this).execute();
    }
}

