/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.util.ArrayList;
import scimat.gui.commands.edit.add.AddReferenceSourcesToReferenceSourceGroupEdit;
import scimat.gui.commands.edit.delete.DeleteReferenceSourceEdit;
import scimat.gui.commands.edit.delete.DeleteReferenceSourceGroupEdit;
import scimat.gui.commands.edit.delete.DeleteReferenceSourcesFromReferenceSourceGroupEdit;
import scimat.gui.commands.edit.move.MoveReferenceSourceToDifferentReferenceSourceGroupEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.itemslist.ReferenceSourceGroupsListPanel;
import scimat.gui.components.itemslist.ReferenceSourcesWithoutGroupListPanel;
import scimat.gui.components.joindialog.JoinEntitiesDialogManager;
import scimat.gui.components.manager.GenericManualSetGroupPanel;
import scimat.gui.components.movetogroup.MoveToGroupDialogManager;
import scimat.gui.components.slavepanel.ReferenceSourceGroupSlaveReferenceSourcesPanel;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSourceGroupManualSetManager
extends GenericManualSetGroupPanel<ReferenceSourceGroup, ReferenceSource> {
    public ReferenceSourceGroupManualSetManager() {
        super(new ReferenceSourceGroupsListPanel(), new ReferenceSourcesWithoutGroupListPanel(), new ReferenceSourceGroupSlaveReferenceSourcesPanel());
        this.setDescription("Sources-reference groups", "Sources-reference of the group", "Sources-reference without group");
    }

    @Override
    public void addGroupAction() {
        AddDialogManager.getInstance().showAddReferenceSourceGroupDialog();
    }

    @Override
    public void editGroupAction(ReferenceSourceGroup group) {
        EditDialogManager.getInstance().showEditReferenceSourceGroupDialog(group);
    }

    @Override
    public void moveGroupToAction(ArrayList<ReferenceSourceGroup> groups) {
        JoinEntitiesDialogManager.getInstance().showReferenceSourceGroupsJoinDialog(groups);
    }

    @Override
    public void deleteGroupAction(ArrayList<ReferenceSourceGroup> groups) {
        new PerformKnowledgeBaseEditTask(new DeleteReferenceSourceGroupEdit(groups), this).execute();
    }

    @Override
    public void toNewGroupAction(ArrayList<ReferenceSource> itemsWithoutGroup) {
        MoveToGroupDialogManager.getInstance().showMoveReferenceSourcesToNewGroupDialog(itemsWithoutGroup);
    }

    @Override
    public void toDifferentGroupAction(ArrayList<ReferenceSource> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new MoveReferenceSourceToDifferentReferenceSourceGroupEdit(itemsWithoutGroup), this).execute();
    }

    @Override
    public void removeItemFromGroupAction(ArrayList<ReferenceSource> itemsFromGroup, ReferenceSourceGroup group) {
        new PerformKnowledgeBaseEditTask(new DeleteReferenceSourcesFromReferenceSourceGroupEdit(itemsFromGroup, group), this).execute();
    }

    @Override
    public void addItemToGroupAction(ReferenceSourceGroup group, ArrayList<ReferenceSource> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new AddReferenceSourcesToReferenceSourceGroupEdit(itemsWithoutGroup, group), this).execute();
    }

    @Override
    public void removeItemsWithoutGroup(ArrayList<ReferenceSource> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new DeleteReferenceSourceEdit(itemsWithoutGroup), this).execute();
    }
}

