/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.util.ArrayList;
import scimat.gui.commands.edit.add.AddReferencesToReferenceGroupEdit;
import scimat.gui.commands.edit.delete.DeleteReferenceEdit;
import scimat.gui.commands.edit.delete.DeleteReferenceGroupEdit;
import scimat.gui.commands.edit.delete.DeleteReferencesFromReferenceGroupEdit;
import scimat.gui.commands.edit.move.MoveReferenceToDifferentReferenceGroupEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.itemslist.ReferenceGroupsListPanel;
import scimat.gui.components.itemslist.ReferencesWithoutGroupListPanel;
import scimat.gui.components.joindialog.JoinEntitiesDialogManager;
import scimat.gui.components.manager.GenericManualSetGroupPanel;
import scimat.gui.components.movetogroup.MoveToGroupDialogManager;
import scimat.gui.components.slavepanel.ReferenceGroupSlaveReferencesPanel;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceGroupManualSetManager
extends GenericManualSetGroupPanel<ReferenceGroup, Reference> {
    public ReferenceGroupManualSetManager() {
        super(new ReferenceGroupsListPanel(), new ReferencesWithoutGroupListPanel(), new ReferenceGroupSlaveReferencesPanel());
        this.setDescription("Reference groups", "References of the group", "References without group");
    }

    @Override
    public void addGroupAction() {
        AddDialogManager.getInstance().showAddReferenceGroupDialog();
    }

    @Override
    public void editGroupAction(ReferenceGroup group) {
        EditDialogManager.getInstance().showEditReferenceGroupDialog(group);
    }

    @Override
    public void moveGroupToAction(ArrayList<ReferenceGroup> groups) {
        JoinEntitiesDialogManager.getInstance().showReferenceGroupsJoinDialog(groups);
    }

    @Override
    public void deleteGroupAction(ArrayList<ReferenceGroup> groups) {
        new PerformKnowledgeBaseEditTask(new DeleteReferenceGroupEdit(groups), this).execute();
    }

    @Override
    public void toNewGroupAction(ArrayList<Reference> itemsWithoutGroup) {
        MoveToGroupDialogManager.getInstance().showMoveReferencesToNewGroupDialog(itemsWithoutGroup);
    }

    @Override
    public void toDifferentGroupAction(ArrayList<Reference> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new MoveReferenceToDifferentReferenceGroupEdit(itemsWithoutGroup), this).execute();
    }

    @Override
    public void removeItemFromGroupAction(ArrayList<Reference> itemsFromGroup, ReferenceGroup group) {
        new PerformKnowledgeBaseEditTask(new DeleteReferencesFromReferenceGroupEdit(itemsFromGroup, group), this).execute();
    }

    @Override
    public void addItemToGroupAction(ReferenceGroup group, ArrayList<Reference> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new AddReferencesToReferenceGroupEdit(itemsWithoutGroup, group), this).execute();
    }

    @Override
    public void removeItemsWithoutGroup(ArrayList<Reference> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new DeleteReferenceEdit(itemsWithoutGroup), this).execute();
    }
}

