/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.itemslist.GenericItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;
import scimat.gui.components.slavepanel.GenericSlaveListPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericManualSetGroupPanel<EM extends Comparable<EM>, ES extends Comparable<ES>>
extends JPanel
implements SelectionObserver {
    private JButton addButton;
    private SelectionObserverButton addItemToGroupButton;
    private SelectionObserverButton deleteButton;
    private SelectionObserverButton deleteGroupButton;
    private SelectionObserverButton editKeywordsGroupsButton;
    private JPanel groupsListPanel;
    private JPanel itemsListSlavePanel;
    private JPanel itemsWithouGroupListPanel;
    private JPanel leftPanel;
    private JScrollPane leftScrollPanel;
    private JSplitPane mainSplitPane;
    private SelectionObserverButton moveToButton;
    private SelectionObserverButton moveToDifferentGroupButton;
    private SelectionObserverButton moveToNewGroupButton;
    private SelectionObserverButton removeItemFromGroupButton;
    private JPanel rightPanel;
    private JScrollPane rightScrollPanel;
    private JSeparator separator;
    private JSeparator separator2;
    private GenericItemsListPanel<EM> genericGroupListPanel;
    private GenericItemsListPanel<ES> genericItemsWithoutGroupListPanel;
    private GenericSlaveListPanel<EM, ES> genericItemsSlaveList;

    public GenericManualSetGroupPanel(GenericItemsListPanel<EM> genericGroupListPanel, GenericItemsListPanel<ES> genericItemsWithoutGroupListPanel, GenericSlaveListPanel<EM, ES> genericItemsSlaveList) {
        this.genericGroupListPanel = genericGroupListPanel;
        this.genericItemsWithoutGroupListPanel = genericItemsWithoutGroupListPanel;
        this.genericItemsSlaveList = genericItemsSlaveList;
        this.initComponents();
        this.groupsListPanel.add(this.genericGroupListPanel);
        this.itemsListSlavePanel.add(this.genericItemsSlaveList);
        this.itemsWithouGroupListPanel.add(this.genericItemsWithoutGroupListPanel);
        this.genericGroupListPanel.addSelectionObserver(this);
    }

    public void setDescription(String groupsTitle, String slaveItemsTitle, String itemsWithOutGroupTitle) {
        this.leftScrollPanel.setBorder(BorderFactory.createTitledBorder(groupsTitle));
        this.itemsListSlavePanel.setBorder(BorderFactory.createTitledBorder(slaveItemsTitle));
        this.itemsWithouGroupListPanel.setBorder(BorderFactory.createTitledBorder(itemsWithOutGroupTitle));
    }

    @Override
    public void selectionChangeHappened(int[] selection) {
        if (selection.length == 0) {
            this.genericItemsSlaveList.setMasterItem(null);
        } else if (selection.length == 1) {
            this.genericItemsSlaveList.setMasterItem(this.genericGroupListPanel.getItem(selection[0]));
        } else {
            this.genericItemsSlaveList.setMasterItem(null);
        }
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.leftScrollPanel = new JScrollPane();
        this.leftPanel = new JPanel();
        this.groupsListPanel = new JPanel();
        this.separator = new JSeparator();
        this.addButton = new JButton();
        this.moveToButton = new SelectionObserverButton(2, -1);
        this.deleteButton = new SelectionObserverButton(1, -1);
        this.editKeywordsGroupsButton = new SelectionObserverButton(1, 1);
        this.rightScrollPanel = new JScrollPane();
        this.rightPanel = new JPanel();
        this.itemsListSlavePanel = new JPanel();
        this.removeItemFromGroupButton = new SelectionObserverButton(1, -1);
        this.addItemToGroupButton = new SelectionObserverButton(1, -1);
        this.itemsWithouGroupListPanel = new JPanel();
        this.separator2 = new JSeparator();
        this.deleteGroupButton = new SelectionObserverButton(1, -1);
        this.moveToNewGroupButton = new SelectionObserverButton(1, -1);
        this.moveToDifferentGroupButton = new SelectionObserverButton(1, -1);
        this.mainSplitPane.setBorder(null);
        this.mainSplitPane.setDividerLocation(400);
        this.leftScrollPanel.setBorder(null);
        this.groupsListPanel.setLayout(new BoxLayout(this.groupsListPanel, 2));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.moveToButton.setText("Move to");
        this.moveToButton.setEnabled(false);
        this.genericGroupListPanel.addSelectionObserver(this.moveToButton);
        this.moveToButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.moveToButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.setEnabled(false);
        this.genericGroupListPanel.addSelectionObserver(this.deleteButton);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.editKeywordsGroupsButton.setText("Edit");
        this.editKeywordsGroupsButton.setEnabled(false);
        this.genericGroupListPanel.addSelectionObserver(this.editKeywordsGroupsButton);
        this.editKeywordsGroupsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.editKeywordsGroupsButtonActionPerformed(evt);
            }
        });
        GroupLayout leftPanelLayout = new GroupLayout(this.leftPanel);
        this.leftPanel.setLayout(leftPanelLayout);
        leftPanelLayout.setHorizontalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addContainerGap().addGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 380, Short.MAX_VALUE).addComponent(this.groupsListPanel, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, leftPanelLayout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editKeywordsGroupsButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveToButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton, -2, -1, -2))).addContainerGap()));
        leftPanelLayout.setVerticalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftPanelLayout.createSequentialGroup().addComponent(this.groupsListPanel, -1, 479, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton, -2, -1, -2).addComponent(this.moveToButton, -2, -1, -2).addComponent(this.addButton).addComponent(this.editKeywordsGroupsButton, -2, -1, -2)).addContainerGap()));
        this.leftScrollPanel.setViewportView(this.leftPanel);
        this.mainSplitPane.setLeftComponent(this.leftScrollPanel);
        this.rightScrollPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.itemsListSlavePanel.setBorder(BorderFactory.createTitledBorder(""));
        this.itemsListSlavePanel.setLayout(new BoxLayout(this.itemsListSlavePanel, 2));
        this.removeItemFromGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/images/down16x16.png")));
        this.removeItemFromGroupButton.setText("");
        this.removeItemFromGroupButton.setEnabled(false);
        this.genericItemsSlaveList.addSelectionObserver(this.removeItemFromGroupButton);
        this.removeItemFromGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.removeItemFromGroupButtonActionPerformed(evt);
            }
        });
        this.addItemToGroupButton.setIcon(new ImageIcon(this.getClass().getResource("/images/up16x16.png")));
        this.addItemToGroupButton.setText("");
        this.addItemToGroupButton.setEnabled(false);
        this.genericItemsWithoutGroupListPanel.addSelectionObserver(new SelectionObserver(){

            public void selectionChangeHappened(int[] selection) {
                if (selection.length > 0 && GenericManualSetGroupPanel.this.genericGroupListPanel.getSelectedRows().length == 1) {
                    GenericManualSetGroupPanel.this.addItemToGroupButton.setEnabled(true);
                } else {
                    GenericManualSetGroupPanel.this.addItemToGroupButton.setEnabled(false);
                }
            }
        });
        this.genericGroupListPanel.addSelectionObserver(new SelectionObserver(){

            public void selectionChangeHappened(int[] selection) {
                if (selection.length == 1 && GenericManualSetGroupPanel.this.genericItemsWithoutGroupListPanel.getSelectedRows().length > 0) {
                    GenericManualSetGroupPanel.this.addItemToGroupButton.setEnabled(true);
                } else {
                    GenericManualSetGroupPanel.this.addItemToGroupButton.setEnabled(false);
                }
            }
        });
        this.addItemToGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.addItemToGroupButtonActionPerformed(evt);
            }
        });
        this.itemsWithouGroupListPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.itemsWithouGroupListPanel.setLayout(new BoxLayout(this.itemsWithouGroupListPanel, 2));
        this.deleteGroupButton.setText("Delete");
        this.deleteGroupButton.setEnabled(false);
        this.genericItemsWithoutGroupListPanel.addSelectionObserver(this.deleteGroupButton);
        this.deleteGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.deleteGroupButtonActionPerformed(evt);
            }
        });
        this.moveToNewGroupButton.setText("To new group");
        this.moveToNewGroupButton.setEnabled(false);
        this.genericItemsWithoutGroupListPanel.addSelectionObserver(this.moveToNewGroupButton);
        this.moveToNewGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.moveToNewGroupButtonActionPerformed(evt);
            }
        });
        this.moveToDifferentGroupButton.setText("To different group");
        this.moveToDifferentGroupButton.setEnabled(false);
        this.genericItemsWithoutGroupListPanel.addSelectionObserver(this.moveToDifferentGroupButton);
        this.moveToDifferentGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericManualSetGroupPanel.this.moveToDifferentGroupButtonActionPerformed(evt);
            }
        });
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addContainerGap().addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemsListSlavePanel, -1, 455, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.CENTER, rightPanelLayout.createSequentialGroup().addComponent(this.addItemToGroupButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeItemFromGroupButton, -2, -1, -2)).addComponent(this.itemsWithouGroupListPanel, GroupLayout.Alignment.CENTER, -1, 455, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, rightPanelLayout.createSequentialGroup().addComponent(this.deleteGroupButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveToNewGroupButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveToDifferentGroupButton, -2, -1, -2)).addComponent(this.separator2, -1, 455, Short.MAX_VALUE)).addContainerGap()));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addComponent(this.itemsListSlavePanel, -1, 164, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.removeItemFromGroupButton, -2, -1, -2).addComponent(this.addItemToGroupButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemsWithouGroupListPanel, -1, 265, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moveToDifferentGroupButton, -2, -1, -2).addComponent(this.moveToNewGroupButton, -2, -1, -2).addComponent(this.deleteGroupButton, -2, -1, -2)).addContainerGap()));
        this.rightScrollPanel.setViewportView(this.rightPanel);
        this.mainSplitPane.setRightComponent(this.rightScrollPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainSplitPane, -1, 892, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainSplitPane, -1, 535, Short.MAX_VALUE));
    }

    public abstract void addGroupAction();

    public abstract void editGroupAction(EM var1);

    public abstract void moveGroupToAction(ArrayList<EM> var1);

    public abstract void deleteGroupAction(ArrayList<EM> var1);

    public abstract void toNewGroupAction(ArrayList<ES> var1);

    public abstract void toDifferentGroupAction(ArrayList<ES> var1);

    public abstract void removeItemFromGroupAction(ArrayList<ES> var1, EM var2);

    public abstract void addItemToGroupAction(EM var1, ArrayList<ES> var2);

    public abstract void removeItemsWithoutGroup(ArrayList<ES> var1);

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addGroupAction();
    }

    private void editKeywordsGroupsButtonActionPerformed(ActionEvent evt) {
        this.editGroupAction((Comparable)this.genericGroupListPanel.getSelectedItems().get(0));
    }

    private void moveToButtonActionPerformed(ActionEvent evt) {
        this.moveGroupToAction(this.genericGroupListPanel.getSelectedItems());
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteGroupAction(this.genericGroupListPanel.getSelectedItems());
    }

    private void moveToNewGroupButtonActionPerformed(ActionEvent evt) {
        this.toNewGroupAction(this.genericItemsWithoutGroupListPanel.getSelectedItems());
    }

    private void moveToDifferentGroupButtonActionPerformed(ActionEvent evt) {
        this.toDifferentGroupAction(this.genericItemsWithoutGroupListPanel.getSelectedItems());
    }

    private void addItemToGroupButtonActionPerformed(ActionEvent evt) {
        this.addItemToGroupAction((Comparable)this.genericGroupListPanel.getSelectedItems().get(0), this.genericItemsWithoutGroupListPanel.getSelectedItems());
    }

    private void removeItemFromGroupButtonActionPerformed(ActionEvent evt) {
        this.removeItemFromGroupAction(this.genericItemsSlaveList.getSelectedItems(), (Comparable)this.genericGroupListPanel.getSelectedItems().get(0));
    }

    private void deleteGroupButtonActionPerformed(ActionEvent evt) {
        this.removeItemsWithoutGroup(this.genericItemsWithoutGroupListPanel.getSelectedItems());
    }
}

