/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.globalslavepanel.GlobalSlavePanel;
import scimat.gui.components.itemslist.GenericItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericItemManagerPanel<E extends Comparable<E>>
extends JPanel
implements SelectionObserver {
    private JButton addButton;
    private SelectionObserverButton deleteButton;
    private JPanel itemsListPanel;
    private JSplitPane mainSplitPanel;
    private JPanel masterPanel;
    private JScrollPane masterScrollPanel;
    private SelectionObserverButton moveToButton;
    private JSeparator separator;
    private JScrollPane slaveScrollPanel;
    private GenericItemsListPanel<E> genericItemsListPanel;
    private GlobalSlavePanel<E> globalSlavePanel;

    public GenericItemManagerPanel(GenericItemsListPanel<E> genericItemsListPanel, GlobalSlavePanel<E> globalSlavePanel) {
        this.genericItemsListPanel = genericItemsListPanel;
        this.globalSlavePanel = globalSlavePanel;
        this.initComponents();
        this.itemsListPanel.add(this.genericItemsListPanel);
        this.slaveScrollPanel.setViewportView(this.globalSlavePanel);
        this.genericItemsListPanel.addSelectionObserver(this);
    }

    public void setMasterPanelTitle(String title) {
        this.masterScrollPanel.setBorder(BorderFactory.createTitledBorder(title));
    }

    public void setSlavePanelTitle(String title) {
        this.slaveScrollPanel.setBorder(BorderFactory.createTitledBorder(title));
    }

    @Override
    public void selectionChangeHappened(int[] selection) {
        if (selection.length == 0) {
            this.globalSlavePanel.refresh(null);
        } else if (selection.length == 1) {
            this.globalSlavePanel.refresh((Comparable)this.genericItemsListPanel.getItem(selection[0]));
        } else {
            this.globalSlavePanel.refresh(null);
        }
    }

    public abstract void addAction();

    public abstract void removeAction(ArrayList<E> var1);

    public abstract void moveToAction(ArrayList<E> var1);

    private void initComponents() {
        this.mainSplitPanel = new JSplitPane();
        this.masterScrollPanel = new JScrollPane();
        this.masterPanel = new JPanel();
        this.itemsListPanel = new JPanel();
        this.separator = new JSeparator();
        this.addButton = new JButton();
        this.moveToButton = new SelectionObserverButton(2, -1);
        this.genericItemsListPanel.addSelectionObserver(this.moveToButton);
        this.deleteButton = new SelectionObserverButton(1, -1);
        this.genericItemsListPanel.addSelectionObserver(this.deleteButton);
        this.slaveScrollPanel = new JScrollPane();
        this.mainSplitPanel.setBorder(null);
        this.mainSplitPanel.setDividerLocation(400);
        this.masterScrollPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.itemsListPanel.setLayout(new BoxLayout(this.itemsListPanel, 2));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericItemManagerPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.moveToButton.setText("Move to");
        this.moveToButton.setEnabled(false);
        this.moveToButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericItemManagerPanel.this.moveToButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericItemManagerPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout masterPanelLayout = new GroupLayout(this.masterPanel);
        this.masterPanel.setLayout(masterPanelLayout);
        masterPanelLayout.setHorizontalGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, masterPanelLayout.createSequentialGroup().addContainerGap().addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.itemsListPanel, GroupLayout.Alignment.LEADING, -1, 368, Short.MAX_VALUE).addGroup(masterPanelLayout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveToButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton, -2, -1, -2)).addComponent(this.separator, GroupLayout.Alignment.LEADING, -1, 368, Short.MAX_VALUE)).addContainerGap()));
        masterPanelLayout.setVerticalGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, masterPanelLayout.createSequentialGroup().addComponent(this.itemsListPanel, -1, 452, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton, -2, -1, -2).addComponent(this.moveToButton, -2, -1, -2).addComponent(this.addButton)).addContainerGap()));
        this.masterScrollPanel.setViewportView(this.masterPanel);
        this.mainSplitPanel.setLeftComponent(this.masterScrollPanel);
        this.slaveScrollPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.mainSplitPanel.setRightComponent(this.slaveScrollPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainSplitPanel, -1, 875, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainSplitPanel, -1, 521, Short.MAX_VALUE));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addAction();
    }

    private void moveToButtonActionPerformed(ActionEvent evt) {
        this.moveToAction(this.genericItemsListPanel.getSelectedItems());
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.removeAction(this.genericItemsListPanel.getSelectedItems());
    }
}

