/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.util.ArrayList;
import scimat.gui.commands.edit.add.AddAuthorReferencesToAuthorReferenceGroupEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorReferenceEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorReferenceGroupEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorReferencesFromAuthorReferenceGroupEdit;
import scimat.gui.commands.edit.move.MoveAuthorReferenceToDifferentAuthorReferenceGroupEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.itemslist.AuthorReferenceGroupsListPanel;
import scimat.gui.components.itemslist.AuthorReferenceWithoutGroupsListPanel;
import scimat.gui.components.joindialog.JoinEntitiesDialogManager;
import scimat.gui.components.manager.GenericManualSetGroupPanel;
import scimat.gui.components.movetogroup.MoveToGroupDialogManager;
import scimat.gui.components.slavepanel.AuthorReferenceGroupSlaveAuthorReferencesPanel;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorReferenceGroupManualSetManager
extends GenericManualSetGroupPanel<AuthorReferenceGroup, AuthorReference> {
    public AuthorReferenceGroupManualSetManager() {
        super(new AuthorReferenceGroupsListPanel(), new AuthorReferenceWithoutGroupsListPanel(), new AuthorReferenceGroupSlaveAuthorReferencesPanel());
        this.setDescription("Authors-reference groups", "Authors-reference of the group", "Authors-reference without group");
    }

    @Override
    public void addGroupAction() {
        AddDialogManager.getInstance().showAddAuthorReferenceGroupDialog();
    }

    @Override
    public void editGroupAction(AuthorReferenceGroup group) {
        EditDialogManager.getInstance().showEditAuthorReferenceGroupDialog(group);
    }

    @Override
    public void moveGroupToAction(ArrayList<AuthorReferenceGroup> groups) {
        JoinEntitiesDialogManager.getInstance().showAuthorReferenceGroupsJoinDialog(groups);
    }

    @Override
    public void deleteGroupAction(ArrayList<AuthorReferenceGroup> groups) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorReferenceGroupEdit(groups), this).execute();
    }

    @Override
    public void toNewGroupAction(ArrayList<AuthorReference> itemsWithoutGroup) {
        MoveToGroupDialogManager.getInstance().showMoveAuthorReferencesToNewGroupDialog(itemsWithoutGroup);
    }

    @Override
    public void toDifferentGroupAction(ArrayList<AuthorReference> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new MoveAuthorReferenceToDifferentAuthorReferenceGroupEdit(itemsWithoutGroup), this).execute();
    }

    @Override
    public void removeItemFromGroupAction(ArrayList<AuthorReference> itemsFromGroup, AuthorReferenceGroup group) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorReferencesFromAuthorReferenceGroupEdit(itemsFromGroup, group), this).execute();
    }

    @Override
    public void addItemToGroupAction(AuthorReferenceGroup group, ArrayList<AuthorReference> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new AddAuthorReferencesToAuthorReferenceGroupEdit(itemsWithoutGroup, group), this).execute();
    }

    @Override
    public void removeItemsWithoutGroup(ArrayList<AuthorReference> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorReferenceEdit(itemsWithoutGroup), this).execute();
    }
}

