/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.manager;

import java.util.ArrayList;
import scimat.gui.commands.edit.add.AddAuthorsToAuthorGroupEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorGroupEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorsFromAuthorGroupEdit;
import scimat.gui.commands.edit.move.MoveAuthorToDifferentAuthorGroupEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.itemslist.AuthorGroupsListPanel;
import scimat.gui.components.itemslist.AuthorWithoutGroupsListPanel;
import scimat.gui.components.joindialog.JoinEntitiesDialogManager;
import scimat.gui.components.manager.GenericManualSetGroupPanel;
import scimat.gui.components.movetogroup.MoveToGroupDialogManager;
import scimat.gui.components.slavepanel.AuthorGroupSlaveAuthorsPanel;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorGroupManualSetManager
extends GenericManualSetGroupPanel<AuthorGroup, Author> {
    public AuthorGroupManualSetManager() {
        super(new AuthorGroupsListPanel(), new AuthorWithoutGroupsListPanel(), new AuthorGroupSlaveAuthorsPanel());
        this.setDescription("Author groups", "Authors of the group", "Authors without group");
    }

    @Override
    public void addGroupAction() {
        AddDialogManager.getInstance().showAddAuthorGroupDialog();
    }

    @Override
    public void editGroupAction(AuthorGroup group) {
        EditDialogManager.getInstance().showEditAuthorGroupDialog(group);
    }

    @Override
    public void moveGroupToAction(ArrayList<AuthorGroup> groups) {
        JoinEntitiesDialogManager.getInstance().showAuthorGroupsJoinDialog(groups);
    }

    @Override
    public void deleteGroupAction(ArrayList<AuthorGroup> groups) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorGroupEdit(groups), this).execute();
    }

    @Override
    public void toNewGroupAction(ArrayList<Author> itemsWithoutGroup) {
        MoveToGroupDialogManager.getInstance().showMoveAuthorsToNewGroupDialog(itemsWithoutGroup);
    }

    @Override
    public void toDifferentGroupAction(ArrayList<Author> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new MoveAuthorToDifferentAuthorGroupEdit(itemsWithoutGroup), this).execute();
    }

    @Override
    public void removeItemFromGroupAction(ArrayList<Author> itemsFromGroup, AuthorGroup group) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorsFromAuthorGroupEdit(itemsFromGroup, group), this).execute();
    }

    @Override
    public void addItemToGroupAction(AuthorGroup group, ArrayList<Author> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new AddAuthorsToAuthorGroupEdit(itemsWithoutGroup, group), this).execute();
    }

    @Override
    public void removeItemsWithoutGroup(ArrayList<Author> itemsWithoutGroup) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorEdit(itemsWithoutGroup), this).execute();
    }
}

