/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.joindialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import scimat.gui.components.itemslist.GenericItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJoinEntitiesDialog<E extends Comparable<E>>
extends JDialog
implements SelectionObserver {
    private JButton cancelButton;
    private JPanel itemsPanel;
    private JButton moveButton;
    private JSeparator separator;
    private GenericItemsListPanel<E> itemListPanel;
    private E targetItem = null;

    public GenericJoinEntitiesDialog(Frame parent, GenericItemsListPanel<E> itemListPanel) {
        super(parent, true);
        this.itemListPanel = itemListPanel;
        this.itemListPanel.setSelectionMode(0);
        this.initComponents();
        this.itemsPanel.add(this.itemListPanel);
        this.itemListPanel.addSelectionObserver(this);
    }

    public void reset() {
        this.targetItem = null;
        this.moveButton.setEnabled(false);
        this.itemListPanel.refreshItems(new ArrayList());
    }

    public void refreshData(ArrayList<E> items) {
        this.targetItem = null;
        this.moveButton.setEnabled(false);
        this.itemListPanel.refreshItems(items);
    }

    @Override
    public void selectionChangeHappened(int[] selection) {
        if (selection.length == 1) {
            this.targetItem = (Comparable)this.itemListPanel.getItem(selection[0]);
            this.moveButton.setEnabled(true);
        } else {
            this.reset();
        }
    }

    public abstract void moveToAction(ArrayList<E> var1, E var2);

    private void initComponents() {
        this.itemsPanel = new JPanel();
        this.separator = new JSeparator();
        this.moveButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Move to");
        this.itemsPanel.setLayout(new BoxLayout(this.itemsPanel, 2));
        this.moveButton.setText("Move");
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericJoinEntitiesDialog.this.moveButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericJoinEntitiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemsPanel, GroupLayout.Alignment.TRAILING, -1, 380, Short.MAX_VALUE).addComponent(this.separator, GroupLayout.Alignment.TRAILING, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.moveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.itemsPanel, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.moveButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void moveButtonActionPerformed(ActionEvent evt) {
        ArrayList<E> sourceItems = this.itemListPanel.getItems();
        sourceItems.remove(this.targetItem);
        this.moveToAction(sourceItems, this.targetItem);
        this.dispose();
    }
}

