/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.itemslist;

import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.gui.components.itemslist.GenericDynamicItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;
import scimat.gui.components.observer.TargetItemSelectedObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSelectOneItemPanel<E extends Comparable<E>>
extends JPanel
implements SelectionObserver {
    private JPanel detailPanel;
    private JPanel sourcePanel;
    private GenericDynamicItemsListPanel<E> sourceListPanel;
    private GenericDetailPanel<E> detailItemPanel;
    private E selectedItem;
    private ArrayList<TargetItemSelectedObserver> targetItemSelecteds = new ArrayList();

    public GenericSelectOneItemPanel(GenericDynamicItemsListPanel<E> sourceListPanel, GenericDetailPanel<E> detailItemPanel) {
        this.sourceListPanel = sourceListPanel;
        this.detailItemPanel = detailItemPanel;
        this.initComponents();
        this.sourceListPanel.setSelectionMode(0);
        this.sourceListPanel.addSelectionObserver(this);
        this.sourcePanel.add(this.sourceListPanel);
        this.detailPanel.add(this.detailItemPanel);
    }

    public void addTargetItemSelectedObserver(TargetItemSelectedObserver o) {
        this.targetItemSelecteds.add(o);
    }

    private void notifyTargetItemSelectedObserver() {
        boolean flag = this.selectedItem != null;
        for (int i = 0; i < this.targetItemSelecteds.size(); ++i) {
            this.targetItemSelecteds.get(i).targetItemSelectionChanged(flag);
        }
    }

    public void reset() {
        this.selectedItem = null;
        this.sourceListPanel.refreshItems(new ArrayList());
        this.detailItemPanel.refreshItem(this.selectedItem);
        this.notifyTargetItemSelectedObserver();
    }

    public void refreshSourceItems(ArrayList<E> items) {
        this.sourceListPanel.refreshItems(items);
        this.detailItemPanel.refreshItem(null);
    }

    @Override
    public void selectionChangeHappened(int[] selection) {
        this.selectedItem = selection.length == 1 ? (Comparable)this.sourceListPanel.getItem(selection[0]) : null;
        this.detailItemPanel.refreshItem(this.selectedItem);
        this.notifyTargetItemSelectedObserver();
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void addNewSourceItem(ArrayList<E> items) {
        this.sourceListPanel.addItems(items);
        this.sourceListPanel.selectLastInsertedRow();
    }

    private void initComponents() {
        this.sourcePanel = new JPanel();
        this.detailPanel = new JPanel();
        this.sourcePanel.setLayout(new BoxLayout(this.sourcePanel, 2));
        this.detailPanel.setLayout(new BoxLayout(this.detailPanel, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.sourcePanel, -1, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailPanel, -1, 126, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourcePanel, -1, 135, Short.MAX_VALUE).addComponent(this.detailPanel, -1, 135, Short.MAX_VALUE));
    }
}

