/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.itemslist;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.itemslist.GenericDynamicItemsListPanel;
import scimat.gui.components.observer.ElementsCountObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSelectManyItemsPanel<E extends Comparable<E>>
extends JPanel {
    private SelectionObserverButton flowLeftButton;
    private SelectionObserverButton flowRightButton;
    private JPanel sourcePanel;
    private JPanel targetPanel;
    private GenericDynamicItemsListPanel<E> sourceListPanel;
    private GenericDynamicItemsListPanel<E> targetListPanel;

    public GenericSelectManyItemsPanel(GenericDynamicItemsListPanel<E> sourceListPanel, GenericDynamicItemsListPanel<E> targetListPanel) {
        this.sourceListPanel = sourceListPanel;
        this.targetListPanel = targetListPanel;
        this.initComponents();
        this.sourcePanel.add(this.sourceListPanel);
        this.targetPanel.add(this.targetListPanel);
    }

    public void refreshData(ArrayList<E> items) {
        this.sourceListPanel.refreshItems(items);
        this.targetListPanel.refreshItems(new ArrayList());
    }

    public ArrayList<E> getTargetItems() {
        return this.targetListPanel.getItems();
    }

    public void addNewTargetItems(ArrayList<E> items) {
        this.targetListPanel.addItems(items);
    }

    public void addTargetElementsCountObserver(ElementsCountObserver observer) {
        this.targetListPanel.addElementsCountObserver(observer);
    }

    private void initComponents() {
        this.sourcePanel = new JPanel();
        this.targetPanel = new JPanel();
        this.flowRightButton = new SelectionObserverButton(1, -1);
        this.flowLeftButton = new SelectionObserverButton(1, -1);
        this.sourcePanel.setLayout(new BoxLayout(this.sourcePanel, 2));
        this.targetPanel.setLayout(new BoxLayout(this.targetPanel, 2));
        this.flowRightButton.setIcon(new ImageIcon(this.getClass().getResource("/images/next24x24.png")));
        this.flowRightButton.setText("");
        this.flowRightButton.setEnabled(false);
        this.sourceListPanel.addSelectionObserver(this.flowRightButton);
        this.flowRightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericSelectManyItemsPanel.this.flowRightButtonActionPerformed(evt);
            }
        });
        this.flowLeftButton.setIcon(new ImageIcon(this.getClass().getResource("/images/back24x24.png")));
        this.flowLeftButton.setText("");
        this.flowLeftButton.setEnabled(false);
        this.targetListPanel.addSelectionObserver(this.flowLeftButton);
        this.flowLeftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericSelectManyItemsPanel.this.flowLeftButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourcePanel, -1, 126, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.flowLeftButton, -2, -1, -2).addComponent(this.flowRightButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetPanel, -1, 126, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourcePanel, GroupLayout.Alignment.CENTER, -1, 218, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.CENTER, layout.createSequentialGroup().addComponent(this.flowRightButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.flowLeftButton, -2, -1, -2)).addComponent(this.targetPanel, -1, 218, Short.MAX_VALUE));
    }

    private void flowRightButtonActionPerformed(ActionEvent evt) {
        this.targetListPanel.addItems(this.sourceListPanel.getSelectedItems());
        this.sourceListPanel.removeItems(this.sourceListPanel.getSelectedItems());
    }

    private void flowLeftButtonActionPerformed(ActionEvent evt) {
        this.sourceListPanel.addItems(this.targetListPanel.getSelectedItems());
        this.targetListPanel.removeItems(this.targetListPanel.getSelectedItems());
    }
}

