/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.itemslist;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import scimat.gui.components.observer.ElementsCountObserver;
import scimat.gui.components.observer.SelectionObserver;
import scimat.gui.components.tablemodel.GenericTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericItemsListPanel<E>
extends JPanel
implements ElementsCountObserver {
    private JButton filterButton;
    private JLabel filterDescriptionLabel;
    private JTextField filterTextField;
    private JLabel itemsCountDescriptionLabel;
    private JLabel itemsCountLabel;
    private JScrollPane scrollPanel;
    private JTable table;
    protected GenericTableModel<E> tableModel;
    private ArrayList<SelectionObserver> selectionObservers;
    private TableRowSorter<GenericTableModel<E>> tableRowSorter;
    private int[] selectedRows;

    public GenericItemsListPanel(GenericTableModel<E> tableModel) {
        this.tableModel = tableModel;
        this.tableRowSorter = new TableRowSorter<GenericTableModel<E>>(tableModel);
        this.tableModel.addElementsCountObserver(this);
        this.selectionObservers = new ArrayList();
        this.selectedRows = new int[0];
        this.initComponents();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GenericItemsListPanel.this.notifySelectionObserver(GenericItemsListPanel.this.table.getSelectedRows());
                }
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                GenericItemsListPanel.this.enableFilterButton();
            }

            public void removeUpdate(DocumentEvent e) {
                GenericItemsListPanel.this.enableFilterButton();
            }

            public void changedUpdate(DocumentEvent e) {
                GenericItemsListPanel.this.enableFilterButton();
            }
        });
    }

    private void enableFilterButton() {
        if (this.filterTextField.getText().isEmpty()) {
            this.filterButton.doClick();
            this.filterButton.setEnabled(false);
        } else {
            this.filterButton.setEnabled(true);
        }
    }

    public E getItem(int rowIndex) {
        return this.tableModel.getItem(rowIndex);
    }

    public ArrayList<E> getItems() {
        return this.tableModel.getItems();
    }

    public ArrayList<E> getSelectedItems() {
        ArrayList<E> items = new ArrayList<E>();
        for (int i = 0; i < this.selectedRows.length; ++i) {
            items.add(this.getItem(this.selectedRows[i]));
        }
        return items;
    }

    public int[] getSelectedRows() {
        return this.selectedRows;
    }

    public void refreshItems(ArrayList<E> items) {
        this.tableModel.refreshItems(items);
    }

    protected GenericTableModel<E> getTableModel() {
        return this.tableModel;
    }

    public void addSelectionObserver(SelectionObserver o) {
        this.selectionObservers.add(o);
    }

    private void notifySelectionObserver(int[] selection) {
        int i;
        this.selectedRows = new int[selection.length];
        for (i = 0; i < selection.length; ++i) {
            this.selectedRows[i] = this.table.convertRowIndexToModel(selection[i]);
        }
        for (i = 0; i < this.selectionObservers.size(); ++i) {
            this.selectionObservers.get(i).selectionChangeHappened(this.selectedRows);
        }
    }

    public void addElementsCountObserver(ElementsCountObserver observer) {
        this.tableModel.addElementsCountObserver(observer);
    }

    @Override
    public void elementsCountChanged(int newElementsCount) {
        this.itemsCountLabel.setText(String.valueOf(newElementsCount));
    }

    public void setSelectionMode(int selection) {
        this.table.setSelectionMode(selection);
    }

    public void selectLastInsertedRow() {
        int position = this.table.convertRowIndexToView(this.tableModel.getRowCount() - 1);
        this.table.setRowSelectionInterval(position, position);
    }

    private void initComponents() {
        this.scrollPanel = new JScrollPane();
        this.table = new JTable();
        this.filterDescriptionLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.filterButton = new JButton();
        this.itemsCountDescriptionLabel = new JLabel();
        this.itemsCountLabel = new JLabel();
        this.table.setModel(this.tableModel);
        this.table.setRowSorter(this.tableRowSorter);
        this.scrollPanel.setViewportView(this.table);
        this.filterDescriptionLabel.setText("Filter:");
        this.filterButton.setText("Filter");
        this.filterButton.setEnabled(false);
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericItemsListPanel.this.filterButtonActionPerformed(evt);
            }
        });
        this.itemsCountDescriptionLabel.setText("Items:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filterDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterTextField, -1, 172, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterButton).addGap(4, 4, 4).addComponent(this.itemsCountDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemsCountLabel).addGap(4, 4, 4)).addComponent(this.scrollPanel, -1, 312, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollPanel, -1, 254, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterDescriptionLabel).addComponent(this.filterTextField, -2, -1, -2).addComponent(this.filterButton).addComponent(this.itemsCountLabel).addComponent(this.itemsCountDescriptionLabel))));
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        if (this.filterTextField.getText().isEmpty()) {
            this.tableRowSorter.setRowFilter(null);
        } else {
            try {
                this.tableRowSorter.setRowFilter(RowFilter.regexFilter(this.filterTextField.getText(), new int[0]));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The filter expresion given is invalid.\nPlease give a valid filter expresion.", "Invalid filter expresion", 0);
            }
        }
    }
}

