/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.globalslavepanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.delete.DeleteAuthorReferencesFromReferenceEdit;
import scimat.gui.commands.edit.delete.DeleteReferenceSourceFromReferenceEdit;
import scimat.gui.commands.edit.update.UpdateReferenceEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.HideAndShowPanel;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.SlaveItemObserverButton;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.detailspanel.ReferenceDetailPanel;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.globalslavepanel.GlobalSlavePanel;
import scimat.gui.components.slavepanel.ReferenceSlaveAuthorReferencesPanel;
import scimat.gui.components.slavepanel.ReferenceSlaveDocumentsPanel;
import scimat.gui.components.slavepanel.ReferenceSlaveReferenceGroupPanel;
import scimat.gui.components.slavepanel.ReferenceSlaveReferenceSourcePanel;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceGlobalSlavePanel
extends GlobalSlavePanel<Reference> {
    private JButton addAuthorReferenceButton;
    private JButton addReferenceSourceButton;
    private JPanel authorReferenceInfoPanel;
    private SelectionObserverButton deleteAuthorReferencesButton;
    private SlaveItemObserverButton deleteReferenceSourceButton;
    private JPanel documentInfoPanel;
    private HideAndShowPanel hideAndShowAuthorReferencePanel;
    private HideAndShowPanel hideAndShowDocumentPanel;
    private HideAndShowPanel hideAndShowReferenceGroupPanel;
    private HideAndShowPanel hideAndShowReferencePanel;
    private HideAndShowPanel hideAndShowReferenceSourcePanel;
    private ReferenceDetailPanel referenceDetailPanel;
    private JPanel referenceGroupInfoPanel;
    private JPanel referenceInfoPanel;
    private ReferenceSlaveAuthorReferencesPanel referenceSlaveAuthorReferencesPanel;
    private ReferenceSlaveDocumentsPanel referenceSlaveDocumentsPanel;
    private ReferenceSlaveReferenceGroupPanel referenceSlaveReferenceGroupPanel;
    private ReferenceSlaveReferenceSourcePanel referenceSlaveReferenceSourcePanel;
    private JPanel referenceSourceInfoPanel;
    private SelectionObserverButton updateAuthorReferencePositionButton;
    private JButton updateReferenceButton;

    public ReferenceGlobalSlavePanel() {
        this.initComponents();
    }

    @Override
    public void refresh(Reference item) {
        this.setMasterItem(item);
        this.referenceDetailPanel.refreshItem(item);
        this.referenceSlaveReferenceGroupPanel.setMasterItem(item);
        this.referenceSlaveReferenceSourcePanel.setMasterItem(item);
        this.referenceSlaveDocumentsPanel.setMasterItem(item);
        this.referenceSlaveAuthorReferencesPanel.setMasterItem(item);
        boolean flag = item != null;
        this.updateReferenceButton.setEnabled(flag);
        this.addAuthorReferenceButton.setEnabled(flag);
        this.addReferenceSourceButton.setEnabled(flag);
    }

    private void initComponents() {
        this.hideAndShowReferencePanel = new HideAndShowPanel();
        this.referenceInfoPanel = new JPanel();
        this.updateReferenceButton = new JButton();
        this.referenceDetailPanel = new ReferenceDetailPanel();
        this.hideAndShowReferenceGroupPanel = new HideAndShowPanel();
        this.referenceGroupInfoPanel = new JPanel();
        this.referenceSlaveReferenceGroupPanel = new ReferenceSlaveReferenceGroupPanel();
        this.hideAndShowReferenceSourcePanel = new HideAndShowPanel();
        this.referenceSourceInfoPanel = new JPanel();
        this.referenceSlaveReferenceSourcePanel = new ReferenceSlaveReferenceSourcePanel();
        this.addReferenceSourceButton = new JButton();
        this.deleteReferenceSourceButton = new SlaveItemObserverButton();
        this.hideAndShowDocumentPanel = new HideAndShowPanel();
        this.documentInfoPanel = new JPanel();
        this.referenceSlaveDocumentsPanel = new ReferenceSlaveDocumentsPanel();
        this.hideAndShowAuthorReferencePanel = new HideAndShowPanel();
        this.authorReferenceInfoPanel = new JPanel();
        this.referenceSlaveAuthorReferencesPanel = new ReferenceSlaveAuthorReferencesPanel();
        this.addAuthorReferenceButton = new JButton();
        this.updateAuthorReferencePositionButton = new SelectionObserverButton(1, 1);
        this.referenceSlaveAuthorReferencesPanel.addSelectionObserver(this.updateAuthorReferencePositionButton);
        this.deleteAuthorReferencesButton = new SelectionObserverButton(1, -1);
        this.referenceSlaveAuthorReferencesPanel.addSelectionObserver(this.deleteAuthorReferencesButton);
        this.hideAndShowReferencePanel.setDescription("Reference info");
        this.hideAndShowReferencePanel.setPanel(this.referenceInfoPanel);
        this.updateReferenceButton.setText("Update");
        this.updateReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferenceGlobalSlavePanel.this.updateReferenceButtonActionPerformed(evt);
            }
        });
        GroupLayout referenceInfoPanelLayout = new GroupLayout(this.referenceInfoPanel);
        this.referenceInfoPanel.setLayout(referenceInfoPanelLayout);
        referenceInfoPanelLayout.setHorizontalGroup(referenceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, referenceInfoPanelLayout.createSequentialGroup().addContainerGap(313, Short.MAX_VALUE).addComponent(this.updateReferenceButton)).addComponent(this.referenceDetailPanel, -1, 380, Short.MAX_VALUE));
        referenceInfoPanelLayout.setVerticalGroup(referenceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, referenceInfoPanelLayout.createSequentialGroup().addComponent(this.referenceDetailPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.updateReferenceButton)));
        this.hideAndShowReferenceGroupPanel.setDescription("Reference group info");
        this.hideAndShowReferenceGroupPanel.setPanel(this.referenceGroupInfoPanel);
        GroupLayout referenceGroupInfoPanelLayout = new GroupLayout(this.referenceGroupInfoPanel);
        this.referenceGroupInfoPanel.setLayout(referenceGroupInfoPanelLayout);
        referenceGroupInfoPanelLayout.setHorizontalGroup(referenceGroupInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceSlaveReferenceGroupPanel, -1, 380, Short.MAX_VALUE));
        referenceGroupInfoPanelLayout.setVerticalGroup(referenceGroupInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceSlaveReferenceGroupPanel, -2, -1, -2));
        this.hideAndShowReferenceSourcePanel.setDescription("Reference source info");
        this.hideAndShowReferenceSourcePanel.setPanel(this.referenceSourceInfoPanel);
        this.addReferenceSourceButton.setText("Set");
        this.addReferenceSourceButton.setEnabled(false);
        this.addReferenceSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferenceGlobalSlavePanel.this.addReferenceSourceButtonActionPerformed(evt);
            }
        });
        this.deleteReferenceSourceButton.setText("Delete");
        this.deleteReferenceSourceButton.setEnabled(false);
        this.referenceSlaveReferenceSourcePanel.addSlaveItemObserver(this.deleteReferenceSourceButton);
        this.deleteReferenceSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferenceGlobalSlavePanel.this.deleteReferenceSourceButtonActionPerformed(evt);
            }
        });
        GroupLayout referenceSourceInfoPanelLayout = new GroupLayout(this.referenceSourceInfoPanel);
        this.referenceSourceInfoPanel.setLayout(referenceSourceInfoPanelLayout);
        referenceSourceInfoPanelLayout.setHorizontalGroup(referenceSourceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceSlaveReferenceSourcePanel, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, referenceSourceInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addReferenceSourceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteReferenceSourceButton, -2, -1, -2)));
        referenceSourceInfoPanelLayout.setVerticalGroup(referenceSourceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(referenceSourceInfoPanelLayout.createSequentialGroup().addComponent(this.referenceSlaveReferenceSourcePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(referenceSourceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addReferenceSourceButton).addComponent(this.deleteReferenceSourceButton, -2, -1, -2))));
        this.hideAndShowDocumentPanel.setDescription("Citing documents info");
        this.hideAndShowDocumentPanel.setPanel(this.referenceSlaveDocumentsPanel);
        GroupLayout documentInfoPanelLayout = new GroupLayout(this.documentInfoPanel);
        this.documentInfoPanel.setLayout(documentInfoPanelLayout);
        documentInfoPanelLayout.setHorizontalGroup(documentInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceSlaveDocumentsPanel, -1, 380, Short.MAX_VALUE));
        documentInfoPanelLayout.setVerticalGroup(documentInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceSlaveDocumentsPanel, -1, 131, Short.MAX_VALUE));
        this.hideAndShowAuthorReferencePanel.setDescription("Author references info");
        this.hideAndShowAuthorReferencePanel.setPanel(this.referenceSlaveAuthorReferencesPanel);
        this.addAuthorReferenceButton.setText("Add");
        this.addAuthorReferenceButton.setEnabled(false);
        this.addAuthorReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferenceGlobalSlavePanel.this.addAuthorReferenceButtonActionPerformed(evt);
            }
        });
        this.updateAuthorReferencePositionButton.setText("Update position");
        this.updateAuthorReferencePositionButton.setEnabled(false);
        this.updateAuthorReferencePositionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferenceGlobalSlavePanel.this.updateAuthorReferencePositionButtonActionPerformed(evt);
            }
        });
        this.deleteAuthorReferencesButton.setText("Delete");
        this.deleteAuthorReferencesButton.setEnabled(false);
        this.deleteAuthorReferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReferenceGlobalSlavePanel.this.deleteAuthorReferencesButtonActionPerformed(evt);
            }
        });
        GroupLayout authorReferenceInfoPanelLayout = new GroupLayout(this.authorReferenceInfoPanel);
        this.authorReferenceInfoPanel.setLayout(authorReferenceInfoPanelLayout);
        authorReferenceInfoPanelLayout.setHorizontalGroup(authorReferenceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, authorReferenceInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addAuthorReferenceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateAuthorReferencePositionButton, -2, -1, -2).addGap(4, 4, 4).addComponent(this.deleteAuthorReferencesButton, -2, -1, -2)).addComponent(this.referenceSlaveAuthorReferencesPanel, -1, 380, Short.MAX_VALUE));
        authorReferenceInfoPanelLayout.setVerticalGroup(authorReferenceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, authorReferenceInfoPanelLayout.createSequentialGroup().addComponent(this.referenceSlaveAuthorReferencesPanel, -1, 158, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authorReferenceInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteAuthorReferencesButton, -2, -1, -2).addComponent(this.updateAuthorReferencePositionButton, -2, -1, -2).addComponent(this.addAuthorReferenceButton))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referenceSourceInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.referenceGroupInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.referenceInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowReferencePanel, -1, 380, Short.MAX_VALUE).addComponent(this.hideAndShowReferenceGroupPanel, -1, 380, Short.MAX_VALUE).addComponent(this.hideAndShowReferenceSourcePanel, -1, 380, Short.MAX_VALUE).addComponent(this.hideAndShowDocumentPanel, -1, 380, Short.MAX_VALUE).addComponent(this.documentInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowAuthorReferencePanel, -1, -1, Short.MAX_VALUE).addComponent(this.authorReferenceInfoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hideAndShowReferencePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowReferenceGroupPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceGroupInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowReferenceSourcePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceSourceInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowDocumentPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowAuthorReferencePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorReferenceInfoPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void updateReferenceButtonActionPerformed(ActionEvent evt) {
        if (this.referenceDetailPanel.getFullReference().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a full reference.\nPlease, give a full reference for the reference.", "Invalid full reference", 0);
        } else {
            PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new UpdateReferenceEdit(((Reference)this.getMasterItem()).getReferenceID(), this.referenceDetailPanel.getFullReference(), this.referenceDetailPanel.getVolume(), this.referenceDetailPanel.getIssue(), this.referenceDetailPanel.getPage(), this.referenceDetailPanel.getYear(), this.referenceDetailPanel.getDoi(), this.referenceDetailPanel.getFormat()), this);
            task.execute();
        }
    }

    private void addReferenceSourceButtonActionPerformed(ActionEvent evt) {
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceSource referenceSource = referenceDAO.getReferenceSource(((Reference)this.getMasterItem()).getReferenceID());
            TreeSet<ReferenceSource> referenceSources = new TreeSet<ReferenceSource>(referenceSourceDAO.getReferenceSources());
            if (referenceSource != null) {
                referenceSources.remove(referenceSource);
            }
            AddDialogManager.getInstance().showAddReferenceSourcesToReferenceDialog((Reference)this.getMasterItem(), new ArrayList<ReferenceSource>(referenceSources));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void deleteReferenceSourceButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteReferenceSourceFromReferenceEdit((Reference)this.getMasterItem()), this).execute();
    }

    private void addAuthorReferenceButtonActionPerformed(ActionEvent evt) {
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            ArrayList<AuthorReference> authorsInDocument = referenceDAO.getAuthorReferences(((Reference)this.getMasterItem()).getReferenceID());
            TreeSet<AuthorReference> possibleAuthors = new TreeSet<AuthorReference>(authorReferenceDAO.getAuthorReferences());
            possibleAuthors.removeAll(authorsInDocument);
            AddDialogManager.getInstance().showAddAuthorReferencesToReferenceDialog((Reference)this.getMasterItem(), new ArrayList<AuthorReference>(possibleAuthors));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void updateAuthorReferencePositionButtonActionPerformed(ActionEvent evt) {
        EditDialogManager.getInstance().showUpdateAuthorReferenceReferencePositionDialog((AuthorReferenceReference)this.referenceSlaveAuthorReferencesPanel.getSelectedItems().get(0));
    }

    private void deleteAuthorReferencesButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorReferencesFromReferenceEdit((Reference)this.getMasterItem(), this.referenceSlaveAuthorReferencesPanel.getSelectedItems()), this).execute();
    }
}

