/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.globalslavepanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.delete.DeletePublishDatesFromPeriodEdit;
import scimat.gui.commands.edit.update.UpdatePeriodEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.HideAndShowPanel;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.detailspanel.PeriodDetailPanel;
import scimat.gui.components.globalslavepanel.GlobalSlavePanel;
import scimat.gui.components.slavepanel.PeriodSlavePublishDatesPanel;
import scimat.model.knowledgebase.dao.PeriodDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodGlobalSlavePanel
extends GlobalSlavePanel<Period> {
    private JButton addPublishDateButton;
    private SelectionObserverButton deletePublishDatesButton;
    private HideAndShowPanel hideAndShowPeriodPanel;
    private HideAndShowPanel hideAndShowPublishDatePanel;
    private PeriodDetailPanel periodDetailPanel;
    private JPanel periodInfoPanel;
    private PeriodSlavePublishDatesPanel periodSlavePublishDatesPanel;
    private JPanel publishDateInfoPanel;
    private JButton updatePeriodButton;

    public PeriodGlobalSlavePanel() {
        this.initComponents();
    }

    @Override
    public void refresh(Period item) {
        this.setMasterItem(item);
        this.periodDetailPanel.refreshItem(item);
        this.periodSlavePublishDatesPanel.setMasterItem(item);
        boolean flag = item != null;
        this.updatePeriodButton.setEnabled(flag);
        this.addPublishDateButton.setEnabled(flag);
    }

    private void initComponents() {
        this.hideAndShowPeriodPanel = new HideAndShowPanel();
        this.periodInfoPanel = new JPanel();
        this.updatePeriodButton = new JButton();
        this.periodDetailPanel = new PeriodDetailPanel();
        this.hideAndShowPublishDatePanel = new HideAndShowPanel();
        this.publishDateInfoPanel = new JPanel();
        this.periodSlavePublishDatesPanel = new PeriodSlavePublishDatesPanel();
        this.addPublishDateButton = new JButton();
        this.deletePublishDatesButton = new SelectionObserverButton(1, -1);
        this.periodSlavePublishDatesPanel.addSelectionObserver(this.deletePublishDatesButton);
        this.hideAndShowPeriodPanel.setDescription("Period info");
        this.hideAndShowPeriodPanel.setPanel(this.periodInfoPanel);
        this.updatePeriodButton.setText("Update");
        this.updatePeriodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodGlobalSlavePanel.this.updatePeriodButtonActionPerformed(evt);
            }
        });
        GroupLayout periodInfoPanelLayout = new GroupLayout(this.periodInfoPanel);
        this.periodInfoPanel.setLayout(periodInfoPanelLayout);
        periodInfoPanelLayout.setHorizontalGroup(periodInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, periodInfoPanelLayout.createSequentialGroup().addContainerGap(313, Short.MAX_VALUE).addComponent(this.updatePeriodButton)).addComponent(this.periodDetailPanel, -1, 380, Short.MAX_VALUE));
        periodInfoPanelLayout.setVerticalGroup(periodInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, periodInfoPanelLayout.createSequentialGroup().addComponent(this.periodDetailPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.updatePeriodButton)));
        this.hideAndShowPublishDatePanel.setDescription("Publish dates info");
        this.hideAndShowPublishDatePanel.setPanel(this.publishDateInfoPanel);
        this.addPublishDateButton.setText("Add");
        this.addPublishDateButton.setEnabled(false);
        this.addPublishDateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodGlobalSlavePanel.this.addPublishDateButtonActionPerformed(evt);
            }
        });
        this.deletePublishDatesButton.setText("Delete");
        this.deletePublishDatesButton.setEnabled(false);
        this.deletePublishDatesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodGlobalSlavePanel.this.deletePublishDatesButtonActionPerformed(evt);
            }
        });
        GroupLayout publishDateInfoPanelLayout = new GroupLayout(this.publishDateInfoPanel);
        this.publishDateInfoPanel.setLayout(publishDateInfoPanelLayout);
        publishDateInfoPanelLayout.setHorizontalGroup(publishDateInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, publishDateInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addPublishDateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deletePublishDatesButton, -2, -1, -2)).addComponent(this.periodSlavePublishDatesPanel, -1, 380, Short.MAX_VALUE));
        publishDateInfoPanelLayout.setVerticalGroup(publishDateInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, publishDateInfoPanelLayout.createSequentialGroup().addComponent(this.periodSlavePublishDatesPanel, -1, 121, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(publishDateInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addPublishDateButton).addComponent(this.deletePublishDatesButton, -2, -1, -2))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.publishDateInfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.periodInfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowPeriodPanel, GroupLayout.Alignment.LEADING, -1, 380, Short.MAX_VALUE).addComponent(this.hideAndShowPublishDatePanel, GroupLayout.Alignment.LEADING, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hideAndShowPeriodPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowPublishDatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publishDateInfoPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void updatePeriodButtonActionPerformed(ActionEvent evt) {
        if (this.periodDetailPanel.getPeriodName().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a name.\nPlease, give a name for the period.", "Invalid period name", 0);
        } else {
            PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new UpdatePeriodEdit(((Period)this.getMasterItem()).getPeriodID(), this.periodDetailPanel.getPeriodName(), this.periodDetailPanel.getPosition()), this);
            task.execute();
        }
    }

    private void deletePublishDatesButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeletePublishDatesFromPeriodEdit((Period)this.getMasterItem(), this.periodSlavePublishDatesPanel.getSelectedItems()), this).execute();
    }

    private void addPublishDateButtonActionPerformed(ActionEvent evt) {
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            ArrayList<PublishDate> publishDatesInDocument = periodDAO.getPublishDates(((Period)this.getMasterItem()).getPeriodID());
            TreeSet<PublishDate> possiblePublishDates = new TreeSet<PublishDate>(publishDateDAO.getPublishDates());
            possiblePublishDates.removeAll(publishDatesInDocument);
            AddDialogManager.getInstance().showAddPublishDatesToPeriodDialog((Period)this.getMasterItem(), new ArrayList<PublishDate>(possiblePublishDates));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }
}

