/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.globalslavepanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.delete.DeleteAffiliationsFromDocumentEdit;
import scimat.gui.commands.edit.delete.DeleteAuthorsFromDocumentEdit;
import scimat.gui.commands.edit.delete.DeleteJournalFromDocumentEdit;
import scimat.gui.commands.edit.delete.DeletePublishDateFromDocumentEdit;
import scimat.gui.commands.edit.delete.DeleteReferencesFromDocumentEdit;
import scimat.gui.commands.edit.delete.DeleteWordsFromDocumentEdit;
import scimat.gui.commands.edit.update.UpdateDocumentEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.HideAndShowPanel;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.SlaveItemObserverButton;
import scimat.gui.components.adddialog.AddDialogManager;
import scimat.gui.components.detailspanel.DocumentDetailPanel;
import scimat.gui.components.editdialog.EditDialogManager;
import scimat.gui.components.globalslavepanel.GlobalSlavePanel;
import scimat.gui.components.slavepanel.DocumentSlaveAffiliationsPanel;
import scimat.gui.components.slavepanel.DocumentSlaveAuthorsPanel;
import scimat.gui.components.slavepanel.DocumentSlaveJournalPanel;
import scimat.gui.components.slavepanel.DocumentSlavePublishDatePanel;
import scimat.gui.components.slavepanel.DocumentSlaveReferencesPanel;
import scimat.gui.components.slavepanel.DocumentSlaveWordsPanel;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentGlobalSlavePanel
extends GlobalSlavePanel<Document> {
    private JButton addAffiliationButton;
    private JButton addAuthorButton;
    private JButton addJournalButton;
    private JButton addPublishDateButton;
    private JButton addReferenceButton;
    private JButton addWordButton;
    private JPanel affiliationsInfoPanel;
    private JPanel authorsInfoPanel;
    private SelectionObserverButton deleteAffiliationsButton;
    private SelectionObserverButton deleteAuthorsButton;
    private SlaveItemObserverButton deleteJournalButton;
    private SlaveItemObserverButton deletePublishDateButton;
    private SelectionObserverButton deleteReferencesButton;
    private SelectionObserverButton deleteWordsButton;
    private DocumentDetailPanel documentDetailPanel;
    private JPanel documentInfoPanel;
    private DocumentSlaveAffiliationsPanel documentSlaveAffiliationsPanel;
    private DocumentSlaveAuthorsPanel documentSlaveAuthorsPanel;
    private DocumentSlaveJournalPanel documentSlaveJournalPanel;
    private DocumentSlavePublishDatePanel documentSlavePublishDatePanel;
    private DocumentSlaveReferencesPanel documentSlaveReferencesPanel;
    private DocumentSlaveWordsPanel documentSlaveWordsPanel;
    private HideAndShowPanel hideAndShowAffiliationPanel;
    private HideAndShowPanel hideAndShowAuthorPanel;
    private HideAndShowPanel hideAndShowDocumentPanel;
    private HideAndShowPanel hideAndShowJournalPanel;
    private HideAndShowPanel hideAndShowPublishDatePanel;
    private HideAndShowPanel hideAndShowReferencePanel;
    private HideAndShowPanel hideAndShowWordPanel;
    private JPanel journalInfoPanel;
    private JPanel publishDateInfoPanel;
    private JPanel referencesInfoPanel;
    private SelectionObserverButton updateAuthorPositionButton;
    private JButton updateDocumentButton;
    private SelectionObserverButton updateWordRolButton;
    private JPanel wordsInfoPanel;

    public DocumentGlobalSlavePanel() {
        this.initComponents();
    }

    @Override
    public void refresh(Document masterItem) {
        this.setMasterItem(masterItem);
        this.documentDetailPanel.refreshItem(masterItem);
        this.documentSlaveJournalPanel.setMasterItem(masterItem);
        this.documentSlavePublishDatePanel.setMasterItem(masterItem);
        this.documentSlaveAffiliationsPanel.setMasterItem(masterItem);
        this.documentSlaveAuthorsPanel.setMasterItem(masterItem);
        this.documentSlaveWordsPanel.setMasterItem(masterItem);
        this.documentSlaveReferencesPanel.setMasterItem(masterItem);
        boolean flag = masterItem != null;
        this.updateDocumentButton.setEnabled(flag);
        this.addAffiliationButton.setEnabled(flag);
        this.addAuthorButton.setEnabled(flag);
        this.addJournalButton.setEnabled(flag);
        this.addPublishDateButton.setEnabled(flag);
        this.addReferenceButton.setEnabled(flag);
        this.addWordButton.setEnabled(flag);
    }

    private void initComponents() {
        this.hideAndShowDocumentPanel = new HideAndShowPanel();
        this.documentInfoPanel = new JPanel();
        this.documentDetailPanel = new DocumentDetailPanel();
        this.updateDocumentButton = new JButton();
        this.hideAndShowJournalPanel = new HideAndShowPanel();
        this.journalInfoPanel = new JPanel();
        this.documentSlaveJournalPanel = new DocumentSlaveJournalPanel();
        this.addJournalButton = new JButton();
        this.deleteJournalButton = new SlaveItemObserverButton();
        this.hideAndShowPublishDatePanel = new HideAndShowPanel();
        this.publishDateInfoPanel = new JPanel();
        this.documentSlavePublishDatePanel = new DocumentSlavePublishDatePanel();
        this.addPublishDateButton = new JButton();
        this.deletePublishDateButton = new SlaveItemObserverButton();
        this.hideAndShowAffiliationPanel = new HideAndShowPanel();
        this.affiliationsInfoPanel = new JPanel();
        this.documentSlaveAffiliationsPanel = new DocumentSlaveAffiliationsPanel();
        this.addAffiliationButton = new JButton();
        this.deleteAffiliationsButton = new SelectionObserverButton(1, -1);
        this.documentSlaveAffiliationsPanel.addSelectionObserver(this.deleteAffiliationsButton);
        this.hideAndShowAuthorPanel = new HideAndShowPanel();
        this.authorsInfoPanel = new JPanel();
        this.documentSlaveAuthorsPanel = new DocumentSlaveAuthorsPanel();
        this.addAuthorButton = new JButton();
        this.deleteAuthorsButton = new SelectionObserverButton(1, -1);
        this.documentSlaveAuthorsPanel.addSelectionObserver(this.deleteAuthorsButton);
        this.updateAuthorPositionButton = new SelectionObserverButton(1, 1);
        this.documentSlaveAuthorsPanel.addSelectionObserver(this.updateAuthorPositionButton);
        this.hideAndShowWordPanel = new HideAndShowPanel();
        this.wordsInfoPanel = new JPanel();
        this.documentSlaveWordsPanel = new DocumentSlaveWordsPanel();
        this.addWordButton = new JButton();
        this.deleteWordsButton = new SelectionObserverButton(1, -1);
        this.documentSlaveWordsPanel.addSelectionObserver(this.deleteWordsButton);
        this.updateWordRolButton = new SelectionObserverButton(1, 1);
        this.documentSlaveWordsPanel.addSelectionObserver(this.updateWordRolButton);
        this.hideAndShowReferencePanel = new HideAndShowPanel();
        this.referencesInfoPanel = new JPanel();
        this.documentSlaveReferencesPanel = new DocumentSlaveReferencesPanel();
        this.addReferenceButton = new JButton();
        this.deleteReferencesButton = new SelectionObserverButton(1, -1);
        this.documentSlaveReferencesPanel.addSelectionObserver(this.deleteReferencesButton);
        this.hideAndShowDocumentPanel.setDescription("Document info");
        this.hideAndShowDocumentPanel.setPanel(this.documentInfoPanel);
        this.updateDocumentButton.setText("Update");
        this.updateDocumentButton.setEnabled(false);
        this.updateDocumentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.updateDocumentButtonActionPerformed(evt);
            }
        });
        GroupLayout documentInfoPanelLayout = new GroupLayout(this.documentInfoPanel);
        this.documentInfoPanel.setLayout(documentInfoPanelLayout);
        documentInfoPanelLayout.setHorizontalGroup(documentInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.documentDetailPanel, -1, 420, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, documentInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.updateDocumentButton)));
        documentInfoPanelLayout.setVerticalGroup(documentInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(documentInfoPanelLayout.createSequentialGroup().addComponent(this.documentDetailPanel, -1, 315, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateDocumentButton)));
        this.hideAndShowJournalPanel.setDescription("Journal info");
        this.hideAndShowJournalPanel.setPanel(this.journalInfoPanel);
        this.addJournalButton.setText("Set");
        this.addJournalButton.setEnabled(false);
        this.addJournalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.addJournalButtonActionPerformed(evt);
            }
        });
        this.deleteJournalButton.setText("Delete");
        this.deleteJournalButton.setEnabled(false);
        this.documentSlaveJournalPanel.addSlaveItemObserver(this.deleteJournalButton);
        this.deleteJournalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.deleteJournalButtonActionPerformed(evt);
            }
        });
        GroupLayout journalInfoPanelLayout = new GroupLayout(this.journalInfoPanel);
        this.journalInfoPanel.setLayout(journalInfoPanelLayout);
        journalInfoPanelLayout.setHorizontalGroup(journalInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.documentSlaveJournalPanel, -1, 420, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, journalInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addJournalButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteJournalButton, -2, -1, -2)));
        journalInfoPanelLayout.setVerticalGroup(journalInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(journalInfoPanelLayout.createSequentialGroup().addComponent(this.documentSlaveJournalPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(journalInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addJournalButton).addComponent(this.deleteJournalButton, -2, -1, -2))));
        this.hideAndShowPublishDatePanel.setDescription("Publish date info");
        this.hideAndShowPublishDatePanel.setPanel(this.publishDateInfoPanel);
        this.addPublishDateButton.setText("Set");
        this.addPublishDateButton.setEnabled(false);
        this.addPublishDateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.addPublishDateButtonActionPerformed(evt);
            }
        });
        this.deletePublishDateButton.setText("Delete");
        this.deletePublishDateButton.setEnabled(false);
        this.documentSlavePublishDatePanel.addSlaveItemObserver(this.deletePublishDateButton);
        this.deletePublishDateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.deletePublishDateButtonActionPerformed(evt);
            }
        });
        GroupLayout publishDateInfoPanelLayout = new GroupLayout(this.publishDateInfoPanel);
        this.publishDateInfoPanel.setLayout(publishDateInfoPanelLayout);
        publishDateInfoPanelLayout.setHorizontalGroup(publishDateInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.documentSlavePublishDatePanel, -1, 420, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, publishDateInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addPublishDateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deletePublishDateButton, -2, -1, -2)));
        publishDateInfoPanelLayout.setVerticalGroup(publishDateInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(publishDateInfoPanelLayout.createSequentialGroup().addComponent(this.documentSlavePublishDatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(publishDateInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deletePublishDateButton, -2, -1, -2).addComponent(this.addPublishDateButton))));
        this.hideAndShowAffiliationPanel.setDescription("Affiliation info");
        this.hideAndShowAffiliationPanel.setPanel(this.affiliationsInfoPanel);
        this.addAffiliationButton.setText("Add");
        this.addAffiliationButton.setEnabled(false);
        this.addAffiliationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.addAffiliationButtonActionPerformed(evt);
            }
        });
        this.deleteAffiliationsButton.setText("Delete");
        this.deleteAffiliationsButton.setEnabled(false);
        this.deleteAffiliationsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.deleteAffiliationsButtonActionPerformed(evt);
            }
        });
        GroupLayout affiliationsInfoPanelLayout = new GroupLayout(this.affiliationsInfoPanel);
        this.affiliationsInfoPanel.setLayout(affiliationsInfoPanelLayout);
        affiliationsInfoPanelLayout.setHorizontalGroup(affiliationsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, affiliationsInfoPanelLayout.createSequentialGroup().addContainerGap(300, Short.MAX_VALUE).addComponent(this.addAffiliationButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteAffiliationsButton, -2, -1, -2)).addComponent(this.documentSlaveAffiliationsPanel, -1, 420, Short.MAX_VALUE));
        affiliationsInfoPanelLayout.setVerticalGroup(affiliationsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, affiliationsInfoPanelLayout.createSequentialGroup().addComponent(this.documentSlaveAffiliationsPanel, -1, 122, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(affiliationsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addAffiliationButton).addComponent(this.deleteAffiliationsButton, -2, -1, -2))));
        this.hideAndShowAuthorPanel.setDescription("Authors info");
        this.hideAndShowAuthorPanel.setPanel(this.authorsInfoPanel);
        this.addAuthorButton.setText("Add");
        this.addAuthorButton.setEnabled(false);
        this.addAuthorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.addAuthorButtonActionPerformed(evt);
            }
        });
        this.deleteAuthorsButton.setText("Delete");
        this.deleteAuthorsButton.setEnabled(false);
        this.deleteAuthorsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.deleteAuthorsButtonActionPerformed(evt);
            }
        });
        this.updateAuthorPositionButton.setText("Update position");
        this.updateAuthorPositionButton.setEnabled(false);
        this.updateAuthorPositionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.updateAuthorPositionButtonActionPerformed(evt);
            }
        });
        GroupLayout authorsInfoPanelLayout = new GroupLayout(this.authorsInfoPanel);
        this.authorsInfoPanel.setLayout(authorsInfoPanelLayout);
        authorsInfoPanelLayout.setHorizontalGroup(authorsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, authorsInfoPanelLayout.createSequentialGroup().addContainerGap(189, Short.MAX_VALUE).addComponent(this.addAuthorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateAuthorPositionButton, -2, -1, -2).addGap(4, 4, 4).addComponent(this.deleteAuthorsButton, -2, -1, -2)).addComponent(this.documentSlaveAuthorsPanel, -1, 420, Short.MAX_VALUE));
        authorsInfoPanelLayout.setVerticalGroup(authorsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, authorsInfoPanelLayout.createSequentialGroup().addComponent(this.documentSlaveAuthorsPanel, -1, 123, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authorsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteAuthorsButton, -2, -1, -2).addComponent(this.updateAuthorPositionButton, -2, -1, -2).addComponent(this.addAuthorButton))));
        this.hideAndShowWordPanel.setDescription("Words info");
        this.hideAndShowWordPanel.setPanel(this.wordsInfoPanel);
        this.addWordButton.setText("Add");
        this.addWordButton.setEnabled(false);
        this.addWordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.addWordButtonActionPerformed(evt);
            }
        });
        this.deleteWordsButton.setText("Delete");
        this.deleteWordsButton.setEnabled(false);
        this.deleteWordsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.deleteWordsButtonActionPerformed(evt);
            }
        });
        this.updateWordRolButton.setText("Update rol");
        this.updateWordRolButton.setEnabled(false);
        this.updateWordRolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.updateWordRolButtonActionPerformed(evt);
            }
        });
        GroupLayout wordsInfoPanelLayout = new GroupLayout(this.wordsInfoPanel);
        this.wordsInfoPanel.setLayout(wordsInfoPanelLayout);
        wordsInfoPanelLayout.setHorizontalGroup(wordsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, wordsInfoPanelLayout.createSequentialGroup().addContainerGap(211, Short.MAX_VALUE).addComponent(this.addWordButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateWordRolButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteWordsButton, -2, -1, -2)).addComponent(this.documentSlaveWordsPanel, -1, 420, Short.MAX_VALUE));
        wordsInfoPanelLayout.setVerticalGroup(wordsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, wordsInfoPanelLayout.createSequentialGroup().addComponent(this.documentSlaveWordsPanel, -1, 123, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(wordsInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteWordsButton, -2, -1, -2).addComponent(this.updateWordRolButton, -2, -1, -2).addComponent(this.addWordButton))));
        this.hideAndShowReferencePanel.setDescription("Reference info");
        this.hideAndShowReferencePanel.setPanel(this.referencesInfoPanel);
        this.addReferenceButton.setText("Add");
        this.addReferenceButton.setEnabled(false);
        this.addReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.addReferenceButtonActionPerformed(evt);
            }
        });
        this.deleteReferencesButton.setText("Delete");
        this.deleteReferencesButton.setEnabled(false);
        this.deleteReferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentGlobalSlavePanel.this.deleteReferencesButtonActionPerformed(evt);
            }
        });
        GroupLayout referencesInfoPanelLayout = new GroupLayout(this.referencesInfoPanel);
        this.referencesInfoPanel.setLayout(referencesInfoPanelLayout);
        referencesInfoPanelLayout.setHorizontalGroup(referencesInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.documentSlaveReferencesPanel, -1, 420, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, referencesInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addReferenceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteReferencesButton, -2, -1, -2)));
        referencesInfoPanelLayout.setVerticalGroup(referencesInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, referencesInfoPanelLayout.createSequentialGroup().addComponent(this.documentSlaveReferencesPanel, -1, 128, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(referencesInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addReferenceButton).addComponent(this.deleteReferencesButton, -2, -1, -2))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.journalInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowDocumentPanel, -1, 420, Short.MAX_VALUE).addComponent(this.documentInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowJournalPanel, -1, 420, Short.MAX_VALUE).addComponent(this.referencesInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.wordsInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.authorsInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.publishDateInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowPublishDatePanel, -1, 420, Short.MAX_VALUE).addComponent(this.hideAndShowAffiliationPanel, -1, 420, Short.MAX_VALUE).addComponent(this.affiliationsInfoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowAuthorPanel, -1, 420, Short.MAX_VALUE).addComponent(this.hideAndShowWordPanel, -1, 420, Short.MAX_VALUE).addComponent(this.hideAndShowReferencePanel, -1, 420, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hideAndShowDocumentPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowJournalPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.journalInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowPublishDatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publishDateInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowAffiliationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.affiliationsInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowAuthorPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorsInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowWordPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordsInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowReferencePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referencesInfoPanel, -2, -1, -2)));
    }

    private void updateDocumentButtonActionPerformed(ActionEvent evt) {
        PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new UpdateDocumentEdit(((Document)this.getMasterItem()).getDocumentID(), this.documentDetailPanel.getTitle(), this.documentDetailPanel.getAbstract(), this.documentDetailPanel.getType(), this.documentDetailPanel.getCitations(), this.documentDetailPanel.getDoi(), this.documentDetailPanel.getSourceIdentifier(), this.documentDetailPanel.getVolume(), this.documentDetailPanel.getIssue(), this.documentDetailPanel.getBeginPage(), this.documentDetailPanel.getEndPage()), this);
        task.execute();
    }

    private void addWordButtonActionPerformed(ActionEvent evt) {
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            ArrayList<Word> wordsInDocument = documentDAO.getWords(((Document)this.getMasterItem()).getDocumentID(), false, false, false);
            TreeSet<Word> possibleWords = new TreeSet<Word>(wordDAO.getWords());
            possibleWords.removeAll(wordsInDocument);
            AddDialogManager.getInstance().showAddWordsToDocumentDialog((Document)this.getMasterItem(), new ArrayList<Word>(possibleWords));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void addAffiliationButtonActionPerformed(ActionEvent evt) {
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            ArrayList<Affiliation> affiliationsInDocument = documentDAO.getAffiliations(((Document)this.getMasterItem()).getDocumentID());
            TreeSet<Affiliation> possibleAffiliations = new TreeSet<Affiliation>(affiliationDAO.getAffiliations());
            possibleAffiliations.removeAll(affiliationsInDocument);
            AddDialogManager.getInstance().showAddAffiliationsToDocumentDialog((Document)this.getMasterItem(), new ArrayList<Affiliation>(possibleAffiliations));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void addReferenceButtonActionPerformed(ActionEvent evt) {
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            ArrayList<Reference> referencesInDocument = documentDAO.getReferences(((Document)this.getMasterItem()).getDocumentID());
            TreeSet<Reference> referenceWords = new TreeSet<Reference>(referenceDAO.getReferences());
            referenceWords.removeAll(referencesInDocument);
            AddDialogManager.getInstance().showAddReferencesToDocumentDialog((Document)this.getMasterItem(), new ArrayList<Reference>(referenceWords));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void deleteAuthorsButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteAuthorsFromDocumentEdit((Document)this.getMasterItem(), this.documentSlaveAuthorsPanel.getSelectedItems()), this).execute();
    }

    private void deleteWordsButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteWordsFromDocumentEdit((Document)this.getMasterItem(), this.documentSlaveWordsPanel.getSelectedItems()), this).execute();
    }

    private void deleteReferencesButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteReferencesFromDocumentEdit((Document)this.getMasterItem(), this.documentSlaveReferencesPanel.getSelectedItems()), this).execute();
    }

    private void deleteAffiliationsButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteAffiliationsFromDocumentEdit((Document)this.getMasterItem(), this.documentSlaveAffiliationsPanel.getSelectedItems()), this).execute();
    }

    private void updateAuthorPositionButtonActionPerformed(ActionEvent evt) {
        EditDialogManager.getInstance().showUpdateDocumentAuthorPositionDialog((DocumentAuthor)this.documentSlaveAuthorsPanel.getSelectedItems().get(0));
    }

    private void updateWordRolButtonActionPerformed(ActionEvent evt) {
        EditDialogManager.getInstance().showUpdateDocumentWordRolDialog((DocumentWord)this.documentSlaveWordsPanel.getSelectedItems().get(0));
    }

    private void deletePublishDateButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeletePublishDateFromDocumentEdit((Document)this.getMasterItem()), this).execute();
    }

    private void deleteJournalButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new DeleteJournalFromDocumentEdit((Document)this.getMasterItem()), this).execute();
    }

    private void addJournalButtonActionPerformed(ActionEvent evt) {
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            Journal journal = documentDAO.getJournal(((Document)this.getMasterItem()).getDocumentID());
            TreeSet<Journal> journals = new TreeSet<Journal>(journalDAO.getJournals());
            if (journal != null) {
                journals.remove(journal);
            }
            AddDialogManager.getInstance().showAddJournalToDocumentDialog((Document)this.getMasterItem(), new ArrayList<Journal>(journals));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void addPublishDateButtonActionPerformed(ActionEvent evt) {
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            PublishDate publishDate = documentDAO.getPublishDate(((Document)this.getMasterItem()).getDocumentID());
            TreeSet<PublishDate> publishDates = new TreeSet<PublishDate>(publishDateDAO.getPublishDates());
            if (publishDate != null) {
                publishDates.remove(publishDate);
            }
            AddDialogManager.getInstance().showAddPublishDateToDocumentDialog((Document)this.getMasterItem(), new ArrayList<PublishDate>(publishDates));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    private void addAuthorButtonActionPerformed(ActionEvent evt) {
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            ArrayList<Author> authorsInDocument = documentDAO.getAuthors(((Document)this.getMasterItem()).getDocumentID());
            TreeSet<Author> possibleAuthors = new TreeSet<Author>(authorDAO.getAuthors());
            possibleAuthors.removeAll(authorsInDocument);
            AddDialogManager.getInstance().showAddAuthorsToDocumentDialog((Document)this.getMasterItem(), new ArrayList<Author>(possibleAuthors));
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }
}

