/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.globalslavepanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.update.UpdateAuthorEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.HideAndShowPanel;
import scimat.gui.components.detailspanel.AuthorDetailPanel;
import scimat.gui.components.globalslavepanel.GlobalSlavePanel;
import scimat.gui.components.slavepanel.AuthorSlaveAffiliationsPanel;
import scimat.gui.components.slavepanel.AuthorSlaveAuthorGroupPanel;
import scimat.gui.components.slavepanel.AuthorSlaveDocumentsPanel;
import scimat.model.knowledgebase.entity.Author;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorGlobalSlavePanel
extends GlobalSlavePanel<Author> {
    private JPanel affiliationInfoPanel;
    private AuthorDetailPanel authorDetailPanel;
    private JPanel authorGroupInfoPanel;
    private JPanel authorInfoPanel;
    private AuthorSlaveAffiliationsPanel authorSlaveAffiliationsPanel;
    private AuthorSlaveAuthorGroupPanel authorSlaveAuthorGroupPanel;
    private AuthorSlaveDocumentsPanel authorSlaveDocumentsPanel;
    private JPanel documentInfoPanel;
    private HideAndShowPanel hideAndShowAffiliationPanel;
    private HideAndShowPanel hideAndShowAuthorGroupPanel;
    private HideAndShowPanel hideAndShowAuthorPanel;
    private HideAndShowPanel hideAndShowDocumentPanel;
    private JButton updateAuthorButton;

    public AuthorGlobalSlavePanel() {
        this.initComponents();
    }

    @Override
    public void refresh(Author item) {
        this.setMasterItem(item);
        this.authorDetailPanel.refreshItem(item);
        this.authorSlaveAuthorGroupPanel.setMasterItem(item);
        this.authorSlaveAffiliationsPanel.setMasterItem(item);
        this.authorSlaveDocumentsPanel.setMasterItem(item);
        if (item != null) {
            this.updateAuthorButton.setEnabled(true);
        } else {
            this.updateAuthorButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.hideAndShowAuthorPanel = new HideAndShowPanel();
        this.authorInfoPanel = new JPanel();
        this.authorDetailPanel = new AuthorDetailPanel();
        this.updateAuthorButton = new JButton();
        this.hideAndShowAuthorGroupPanel = new HideAndShowPanel();
        this.authorGroupInfoPanel = new JPanel();
        this.authorSlaveAuthorGroupPanel = new AuthorSlaveAuthorGroupPanel();
        this.hideAndShowAffiliationPanel = new HideAndShowPanel();
        this.affiliationInfoPanel = new JPanel();
        this.authorSlaveAffiliationsPanel = new AuthorSlaveAffiliationsPanel();
        this.hideAndShowDocumentPanel = new HideAndShowPanel();
        this.documentInfoPanel = new JPanel();
        this.authorSlaveDocumentsPanel = new AuthorSlaveDocumentsPanel();
        this.hideAndShowAuthorPanel.setDescription("Author info");
        this.hideAndShowAuthorPanel.setPanel(this.authorInfoPanel);
        this.updateAuthorButton.setText("Update");
        this.updateAuthorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthorGlobalSlavePanel.this.updateAuthorButtonActionPerformed(evt);
            }
        });
        GroupLayout authorInfoPanelLayout = new GroupLayout(this.authorInfoPanel);
        this.authorInfoPanel.setLayout(authorInfoPanelLayout);
        authorInfoPanelLayout.setHorizontalGroup(authorInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, authorInfoPanelLayout.createSequentialGroup().addContainerGap(313, Short.MAX_VALUE).addComponent(this.updateAuthorButton)).addComponent(this.authorDetailPanel, -1, 380, Short.MAX_VALUE));
        authorInfoPanelLayout.setVerticalGroup(authorInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, authorInfoPanelLayout.createSequentialGroup().addComponent(this.authorDetailPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.updateAuthorButton)));
        this.hideAndShowAuthorGroupPanel.setDescription("Author group info");
        this.hideAndShowAuthorGroupPanel.setPanel(this.authorGroupInfoPanel);
        GroupLayout authorGroupInfoPanelLayout = new GroupLayout(this.authorGroupInfoPanel);
        this.authorGroupInfoPanel.setLayout(authorGroupInfoPanelLayout);
        authorGroupInfoPanelLayout.setHorizontalGroup(authorGroupInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorSlaveAuthorGroupPanel, -1, 380, Short.MAX_VALUE));
        authorGroupInfoPanelLayout.setVerticalGroup(authorGroupInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authorGroupInfoPanelLayout.createSequentialGroup().addComponent(this.authorSlaveAuthorGroupPanel, -2, -1, -2).addContainerGap(40, Short.MAX_VALUE)));
        this.hideAndShowAffiliationPanel.setDescription("Affiliations info");
        this.hideAndShowAffiliationPanel.setPanel(this.affiliationInfoPanel);
        GroupLayout affiliationInfoPanelLayout = new GroupLayout(this.affiliationInfoPanel);
        this.affiliationInfoPanel.setLayout(affiliationInfoPanelLayout);
        affiliationInfoPanelLayout.setHorizontalGroup(affiliationInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorSlaveAffiliationsPanel, -1, 380, Short.MAX_VALUE));
        affiliationInfoPanelLayout.setVerticalGroup(affiliationInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorSlaveAffiliationsPanel, -1, 131, Short.MAX_VALUE));
        this.hideAndShowDocumentPanel.setDescription("Documents info");
        this.hideAndShowDocumentPanel.setPanel(this.documentInfoPanel);
        GroupLayout documentInfoPanelLayout = new GroupLayout(this.documentInfoPanel);
        this.documentInfoPanel.setLayout(documentInfoPanelLayout);
        documentInfoPanelLayout.setHorizontalGroup(documentInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorSlaveDocumentsPanel, -1, 380, Short.MAX_VALUE));
        documentInfoPanelLayout.setVerticalGroup(documentInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorSlaveDocumentsPanel, -1, 164, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.documentInfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.authorInfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowAuthorPanel, GroupLayout.Alignment.LEADING, -1, 380, Short.MAX_VALUE).addComponent(this.hideAndShowAuthorGroupPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.authorGroupInfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowAffiliationPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.affiliationInfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.hideAndShowDocumentPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hideAndShowAuthorPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowAuthorGroupPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorGroupInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowAffiliationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.affiliationInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowDocumentPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentInfoPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void updateAuthorButtonActionPerformed(ActionEvent evt) {
        if (this.authorDetailPanel.getAuthorName().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a name.\nPlease, give a name for the author.", "Invalid author name", 0);
        } else if (this.authorDetailPanel.getFullAuthorName().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a full name.\nPlease, give a full name for the author.", "Invalid full author name", 0);
        } else {
            PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new UpdateAuthorEdit(((Author)this.getMasterItem()).getAuthorID(), this.authorDetailPanel.getAuthorName(), this.authorDetailPanel.getFullAuthorName()), this);
            task.execute();
        }
    }
}

