/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.globalreplace;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.globalreplace.GlobalReplaceJournalsEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.gui.components.globalreplace.GlobalReplaceSelectFieldsPanel;

public class GlobalReplaceJournalPanel
extends GlobalReplaceSelectFieldsPanel {
    private JCheckBox conferenceInformationCheckBox;
    private JCheckBox sourceCheckBox;
    private int fieldsSelected = 0;

    public GlobalReplaceJournalPanel() {
        this.initComponents();
    }

    public void fireIncorrectDataObservers() {
        if (this.fieldsSelected > 0) {
            this.notifyIncorrectDataObservers(true, "");
        } else {
            this.notifyIncorrectDataObservers(false, "A set of fields must be selected");
        }
    }

    public void doGlobalReplaceAction(String find, String replace) {
        new PerformKnowledgeBaseEditTask(new GlobalReplaceJournalsEdit(find, replace, this.sourceCheckBox.isSelected(), this.conferenceInformationCheckBox.isSelected()), this).execute();
    }

    private void initComponents() {
        this.sourceCheckBox = new JCheckBox();
        this.conferenceInformationCheckBox = new JCheckBox();
        this.sourceCheckBox.setText("Source");
        this.sourceCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GlobalReplaceJournalPanel.this.sourceCheckBoxActionPerformed(evt);
            }
        });
        this.conferenceInformationCheckBox.setText("Conference information");
        this.conferenceInformationCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GlobalReplaceJournalPanel.this.conferenceInformationCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCheckBox).addComponent(this.conferenceInformationCheckBox))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sourceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conferenceInformationCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sourceCheckBoxActionPerformed(ActionEvent evt) {
        this.fieldsSelected = this.sourceCheckBox.isSelected() ? ++this.fieldsSelected : --this.fieldsSelected;
        this.fireIncorrectDataObservers();
    }

    private void conferenceInformationCheckBoxActionPerformed(ActionEvent evt) {
        this.fieldsSelected = this.conferenceInformationCheckBox.isSelected() ? ++this.fieldsSelected : --this.fieldsSelected;
        this.fireIncorrectDataObservers();
    }
}

