/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.globalreplace;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import scimat.gui.components.IncorrectDataObserver;
import scimat.gui.components.globalreplace.GlobalReplaceSelectFieldsPanel;

public class GlobalReplaceDialog
extends JDialog
implements IncorrectDataObserver {
    private JButton acceptButton;
    private JButton cancelButton;
    private JPanel errorPanel;
    private JLabel findLabel;
    private JTextField findTextField;
    private JLabel messageErrorLabel;
    private JLabel replaceLabel;
    private JTextField replaceTextField;
    private JScrollPane selectEntityFieldsScrollPane;
    private JSeparator separator;
    private GlobalReplaceSelectFieldsPanel globalReplaceDoActionPanel;
    private boolean validFindText = false;
    private boolean validSelectedFields = false;

    public GlobalReplaceDialog(Frame parent, GlobalReplaceSelectFieldsPanel globalReplaceDoActionPanel) {
        super(parent, true);
        this.initComponents();
        this.globalReplaceDoActionPanel = globalReplaceDoActionPanel;
        this.selectEntityFieldsScrollPane.setViewportView(this.globalReplaceDoActionPanel);
        this.findTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                GlobalReplaceDialog.this.checkFindText();
            }

            public void removeUpdate(DocumentEvent e) {
                GlobalReplaceDialog.this.checkFindText();
            }

            public void changedUpdate(DocumentEvent e) {
                GlobalReplaceDialog.this.checkFindText();
            }
        });
        this.globalReplaceDoActionPanel.addIncorrectDataObserver(this);
    }

    public void checkFindText() {
        String findText = this.findTextField.getText();
        if (findText.isEmpty()) {
            this.updateErrorMessage("You must provide a find expression");
            this.validFindText = false;
        } else {
            try {
                Pattern.compile(findText);
                this.updateErrorMessage("");
                this.validFindText = true;
            }
            catch (PatternSyntaxException exception) {
                this.updateErrorMessage("Expression syntax incorrect.");
                this.validFindText = false;
            }
        }
        this.enableAcceptButton();
    }

    public void incorrectData(boolean correct, String message) {
        this.validSelectedFields = correct;
        this.updateErrorMessage(message);
        this.enableAcceptButton();
    }

    private void enableAcceptButton() {
        this.acceptButton.setEnabled(this.validFindText && this.validSelectedFields);
    }

    private void updateErrorMessage(String message) {
        if (!this.validFindText || !this.validSelectedFields) {
            this.messageErrorLabel.setText(message);
            this.messageErrorLabel.setForeground(Color.RED);
        } else {
            this.messageErrorLabel.setText("Correct arguments!");
            this.messageErrorLabel.setForeground(new Color(0, 99, 0));
        }
    }

    private void initComponents() {
        this.selectEntityFieldsScrollPane = new JScrollPane();
        this.findLabel = new JLabel();
        this.findTextField = new JTextField();
        this.replaceLabel = new JLabel();
        this.replaceTextField = new JTextField();
        this.separator = new JSeparator();
        this.acceptButton = new JButton();
        this.cancelButton = new JButton();
        this.errorPanel = new JPanel();
        this.messageErrorLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.selectEntityFieldsScrollPane.setBorder(BorderFactory.createTitledBorder("Entity fields"));
        this.findLabel.setText("Find What:");
        this.replaceLabel.setText("Replace With:");
        this.acceptButton.setText("Accept");
        this.acceptButton.setEnabled(false);
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GlobalReplaceDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GlobalReplaceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout errorPanelLayout = new GroupLayout(this.errorPanel);
        this.errorPanel.setLayout(errorPanelLayout);
        errorPanelLayout.setHorizontalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(errorPanelLayout.createSequentialGroup().addComponent(this.messageErrorLabel).addContainerGap(380, Short.MAX_VALUE)));
        errorPanelLayout.setVerticalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageErrorLabel));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectEntityFieldsScrollPane, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.findLabel).addGap(18, 18, 18).addComponent(this.findTextField, -1, 309, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.replaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceTextField, -1, 309, Short.MAX_VALUE)).addComponent(this.errorPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.separator, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.acceptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.selectEntityFieldsScrollPane, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findLabel).addComponent(this.findTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceLabel).addComponent(this.replaceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorPanel, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.acceptButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        this.globalReplaceDoActionPanel.doGlobalReplaceAction(this.findTextField.getText(), this.replaceTextField.getText());
        this.dispose();
    }
}

