/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.editdialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import scimat.gui.commands.edit.update.UpdateDocumentWordRolEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.model.knowledgebase.entity.DocumentWord;

public class UpdateDocumentWordRolDialog
extends JDialog {
    private JCheckBox addedKeywordCheckBox;
    private JCheckBox authorKeywordCheckBox;
    private JButton cancelButton;
    private JSeparator separator;
    private JCheckBox sourceKeywordCheckBox;
    private JButton updateButton;
    private DocumentWord documentWord;

    public UpdateDocumentWordRolDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    public void refreshData(DocumentWord documentWord) {
        this.documentWord = documentWord;
        this.authorKeywordCheckBox.setSelected(this.documentWord.isAuthorKeyword());
        this.sourceKeywordCheckBox.setSelected(this.documentWord.isSourceKeyword());
        this.addedKeywordCheckBox.setSelected(this.documentWord.isAddedKeyword());
    }

    private void initComponents() {
        this.authorKeywordCheckBox = new JCheckBox();
        this.sourceKeywordCheckBox = new JCheckBox();
        this.addedKeywordCheckBox = new JCheckBox();
        this.separator = new JSeparator();
        this.updateButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Update word rol");
        this.authorKeywordCheckBox.setText("Author keyword");
        this.sourceKeywordCheckBox.setText("Source keyword");
        this.addedKeywordCheckBox.setText("Added keyword");
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateDocumentWordRolDialog.this.updateButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateDocumentWordRolDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.separator, -1, 231, Short.MAX_VALUE).add((Component)this.authorKeywordCheckBox).add((Component)this.sourceKeywordCheckBox).add((Component)this.addedKeywordCheckBox).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.updateButton).addPreferredGap(0).add((Component)this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.authorKeywordCheckBox).addPreferredGap(0).add((Component)this.sourceKeywordCheckBox).addPreferredGap(0).add((Component)this.addedKeywordCheckBox).addPreferredGap(0).add((Component)this.separator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.updateButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        new PerformKnowledgeBaseEditTask(new UpdateDocumentWordRolEdit(this.documentWord.getDocument().getDocumentID(), this.documentWord.getWord().getWordID(), this.authorKeywordCheckBox.isSelected(), this.sourceKeywordCheckBox.isSelected(), this.addedKeywordCheckBox.isSelected()), this.rootPane).execute();
        this.dispose();
    }
}

