/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.editdialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.update.UpdateAuthorReferenceGroupEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;

public class EditAuthorReferenceGroupDialog
extends JDialog {
    private JButton cancelButton;
    private JButton editButton;
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JSeparator separator;
    private JCheckBox stopGroupCheckBox;
    private AuthorReferenceGroup authorReferenceGroup = null;

    public EditAuthorReferenceGroupDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    public void refreshData(AuthorReferenceGroup authorReferenceGroup) {
        this.authorReferenceGroup = authorReferenceGroup;
        if (this.authorReferenceGroup != null) {
            this.groupNameTextField.setText(this.authorReferenceGroup.getGroupName());
            this.stopGroupCheckBox.setSelected(this.authorReferenceGroup.isStopGroup());
        }
    }

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.stopGroupCheckBox = new JCheckBox();
        this.separator = new JSeparator();
        this.editButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add author reference group");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.groupNameDescriptionLabel.setLabelFor(this.groupNameTextField);
        this.groupNameDescriptionLabel.setText("Group name:");
        this.stopGroupCheckBox.setText("I stop group?");
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditAuthorReferenceGroupDialog.this.editButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditAuthorReferenceGroupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, GroupLayout.Alignment.TRAILING, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.groupNameDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupNameTextField, -1, 314, Short.MAX_VALUE)).addComponent(this.stopGroupCheckBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameDescriptionLabel).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stopGroupCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.editButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        if (this.groupNameTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a group name.\nPlease, give a name for the group.", "Invalid group name", 0);
        } else {
            PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new UpdateAuthorReferenceGroupEdit(this.authorReferenceGroup.getAuthorReferenceGroupID(), this.groupNameTextField.getText(), this.stopGroupCheckBox.isSelected()), this.rootPane);
            task.execute();
            if (task.isSuccessful()) {
                this.dispose();
            }
        }
    }
}

