/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordGroupDetailPanel
extends GenericDetailPanel<WordGroup> {
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel nameDescriptionLabel;
    private JTextField nameTextField;
    private JCheckBox stopGroupCheckBox;
    private WordGroup wordGroup;

    public WordGroupDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addWordGroupObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.stopGroupCheckBox.setSelected(false);
        this.nameTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.stopGroupCheckBox.setEnabled(enabled);
        this.nameTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(WordGroup wordGroup) {
        this.wordGroup = wordGroup;
        if (wordGroup != null) {
            this.idTextField.setText(this.wordGroup.getWordGroupID().toString());
            this.stopGroupCheckBox.setSelected(this.wordGroup.isStopGroup());
            this.nameTextField.setText(this.wordGroup.getGroupName());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getGroupName() {
        return this.nameTextField.getText();
    }

    public boolean isStopGroup() {
        return this.stopGroupCheckBox.isSelected();
    }

    @Override
    public void entityAdded(ArrayList<WordGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<WordGroup> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.wordGroup);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<WordGroup> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idTextField = new JTextField();
        this.idDescriptionLabel = new JLabel();
        this.stopGroupCheckBox = new JCheckBox();
        this.nameTextField = new JTextField();
        this.nameDescriptionLabel = new JLabel();
        this.idTextField.setEditable(false);
        this.idDescriptionLabel.setText("ID:");
        this.stopGroupCheckBox.setText("Stop group");
        this.nameDescriptionLabel.setText("Name:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.nameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopGroupCheckBox).addContainerGap()).addComponent(this.nameTextField, -1, 173, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2).addComponent(this.stopGroupCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameDescriptionLabel).addComponent(this.nameTextField, -2, -1, -2))));
    }
}

