/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordDetailPanel
extends GenericDetailPanel<Word> {
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel nameDescriptionLabel;
    private JTextField nameTextField;
    private Word word;

    public WordDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addWordObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.nameTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.nameTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Word word) {
        this.word = word;
        if (word != null) {
            this.idTextField.setText(this.word.getWordID().toString());
            this.nameTextField.setText(this.word.getWordName());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getWordName() {
        return this.nameTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<Word> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Word> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.word);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<Word> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.nameDescriptionLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEnabled(false);
        this.nameDescriptionLabel.setText("Name:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.nameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 89, -2).addContainerGap()).addComponent(this.nameTextField, -1, 203, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameDescriptionLabel).addComponent(this.nameTextField, -2, -1, -2))));
    }
}

