/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSourceDetailPanel
extends GenericDetailPanel<ReferenceSource> {
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel sourceDescriptionLabel;
    private JTextField sourceTextField;
    private ReferenceSource referenceSource;

    public ReferenceSourceDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addReferenceSourceObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.sourceTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.sourceTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(ReferenceSource referenceSource) {
        this.referenceSource = referenceSource;
        if (referenceSource != null) {
            this.idTextField.setText(this.referenceSource.getReferenceSourceID().toString());
            this.sourceTextField.setText(this.referenceSource.getSource());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public void setEditable(boolean editable) {
        this.sourceTextField.setEditable(editable);
    }

    public String getSource() {
        return this.sourceTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<ReferenceSource> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<ReferenceSource> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.referenceSource);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<ReferenceSource> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.sourceDescriptionLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEditable(false);
        this.sourceDescriptionLabel.setText("Source:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.sourceDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceTextField, -1, 185, Short.MAX_VALUE).addComponent(this.idTextField, -2, 56, -2)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceDescriptionLabel).addComponent(this.sourceTextField, -2, -1, -2))));
    }
}

