/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceDetailPanel
extends GenericDetailPanel<Reference> {
    private JLabel doiDescriptionLabel;
    private JTextField doiTextField;
    private JLabel formatDescriptionLabel;
    private JTextField formatTextField;
    private JLabel fullReferenceDescriptionLabel;
    private JTextField fullReferenceTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel issueDescriptionLabel;
    private JTextField issueTextField;
    private JLabel pagesDescriptionLabel;
    private JTextField pagesTextField;
    private JLabel volumeDescriptionLabel;
    private JTextField volumeTextField;
    private JLabel yearDescriptionLabel;
    private JTextField yearTextField;
    private Reference reference;

    public ReferenceDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addReferenceObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.formatTextField.setText("");
        this.fullReferenceTextField.setText("");
        this.issueTextField.setText("");
        this.volumeTextField.setText("");
        this.pagesTextField.setText("");
        this.yearTextField.setText("");
        this.doiTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.formatTextField.setEnabled(enabled);
        this.fullReferenceTextField.setEnabled(enabled);
        this.issueTextField.setEnabled(enabled);
        this.volumeTextField.setEnabled(enabled);
        this.pagesTextField.setEnabled(enabled);
        this.yearTextField.setEnabled(enabled);
        this.doiTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Reference reference) {
        this.reference = reference;
        if (reference != null) {
            this.idTextField.setText(this.reference.getReferenceID().toString());
            this.formatTextField.setText(this.reference.getFormat());
            this.fullReferenceTextField.setText(this.reference.getFullReference());
            this.issueTextField.setText(this.reference.getIssue());
            this.volumeTextField.setText(this.reference.getVolume());
            this.pagesTextField.setText(this.reference.getPage());
            this.yearTextField.setText(this.reference.getYear());
            this.doiTextField.setText(this.reference.getDoi());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getFormat() {
        return this.formatTextField.getText();
    }

    public String getFullReference() {
        return this.fullReferenceTextField.getText();
    }

    public String getIssue() {
        return this.issueTextField.getText();
    }

    public String getVolume() {
        return this.volumeTextField.getText();
    }

    public String getPage() {
        return this.pagesTextField.getText();
    }

    public String getYear() {
        return this.yearTextField.getText();
    }

    public String getDoi() {
        return this.doiTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<Reference> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Reference> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.reference);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<Reference> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.formatDescriptionLabel = new JLabel();
        this.formatTextField = new JTextField();
        this.fullReferenceDescriptionLabel = new JLabel();
        this.fullReferenceTextField = new JTextField();
        this.issueDescriptionLabel = new JLabel();
        this.volumeDescriptionLabel = new JLabel();
        this.volumeTextField = new JTextField();
        this.pagesDescriptionLabel = new JLabel();
        this.pagesTextField = new JTextField();
        this.yearDescriptionLabel = new JLabel();
        this.yearTextField = new JTextField();
        this.doiDescriptionLabel = new JLabel();
        this.doiTextField = new JTextField();
        this.issueTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEditable(false);
        this.formatDescriptionLabel.setText("Format:");
        this.fullReferenceDescriptionLabel.setText("Full reference:");
        this.issueDescriptionLabel.setText("Issue:");
        this.volumeDescriptionLabel.setText("Volume:");
        this.pagesDescriptionLabel.setText("Pages:");
        this.yearDescriptionLabel.setText("Year:");
        this.doiDescriptionLabel.setText("Doi:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.fullReferenceDescriptionLabel).addComponent(this.issueDescriptionLabel).addComponent(this.doiDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatTextField, -1, 170, Short.MAX_VALUE)).addComponent(this.doiTextField, -1, 292, Short.MAX_VALUE).addComponent(this.fullReferenceTextField, -1, 292, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.issueTextField, -1, 55, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeDescriptionLabel, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeTextField, -1, 43, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pagesDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pagesTextField, -1, 37, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearTextField, -1, 36, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2).addComponent(this.formatDescriptionLabel).addComponent(this.formatTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fullReferenceDescriptionLabel).addComponent(this.fullReferenceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.issueDescriptionLabel).addComponent(this.volumeDescriptionLabel).addComponent(this.volumeTextField, -2, -1, -2).addComponent(this.pagesDescriptionLabel).addComponent(this.pagesTextField, -2, -1, -2).addComponent(this.yearDescriptionLabel).addComponent(this.yearTextField, -2, -1, -2).addComponent(this.issueTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doiDescriptionLabel).addComponent(this.doiTextField, -2, -1, -2))));
    }
}

