/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishDateDetailPanel
extends GenericDetailPanel<PublishDate> {
    private JLabel dateDescriptionLabel;
    private JTextField dateTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel yearDescriptionLabel;
    private JTextField yearTextField;
    private PublishDate publishDate;

    public PublishDateDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addPublishDateObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.yearTextField.setText("");
        this.dateTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.yearTextField.setEnabled(enabled);
        this.dateTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(PublishDate publishDate) {
        this.publishDate = publishDate;
        if (publishDate != null) {
            this.idTextField.setText(this.publishDate.getPublishDateID().toString());
            this.yearTextField.setText(this.publishDate.getYear());
            this.dateTextField.setText(this.publishDate.getDate());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getYear() {
        return this.yearTextField.getText();
    }

    public String getDate() {
        return this.dateTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<PublishDate> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<PublishDate> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.publishDate);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<PublishDate> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.yearDescriptionLabel = new JLabel();
        this.yearTextField = new JTextField();
        this.dateDescriptionLabel = new JLabel();
        this.dateTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEnabled(false);
        this.yearDescriptionLabel.setText("Year:");
        this.dateDescriptionLabel.setText("Date:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.dateDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateTextField, -1, 140, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearTextField, -2, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2).addComponent(this.yearDescriptionLabel).addComponent(this.yearTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateDescriptionLabel).addComponent(this.dateTextField, -2, -1, -2))));
    }
}

