/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodDetailPanel
extends GenericDetailPanel<Period> {
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel nameDescriptionLabel;
    private JTextField nameTextField;
    private JLabel positionDescriptionLabel;
    private JSpinner positionSpinner;
    private Period period;

    public PeriodDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addPeriodObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.nameTextField.setText("");
        this.positionSpinner.setValue(1);
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.nameTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Period period) {
        this.period = period;
        if (period != null) {
            this.idTextField.setText(this.period.getPeriodID().toString());
            this.nameTextField.setText(this.period.getName());
            this.positionSpinner.setValue(this.period.getPosition());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getPeriodName() {
        return this.nameTextField.getText();
    }

    public int getPosition() {
        return (Integer)this.positionSpinner.getValue();
    }

    @Override
    public void entityAdded(ArrayList<Period> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Period> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.period);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<Period> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.nameDescriptionLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.positionDescriptionLabel = new JLabel();
        this.positionSpinner = new JSpinner();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEnabled(false);
        this.nameDescriptionLabel.setText("Name:");
        this.positionDescriptionLabel.setText("Position");
        this.positionSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameDescriptionLabel).addComponent(this.idDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idTextField, -2, 89, -2).addComponent(this.nameTextField, -1, 227, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.positionDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.positionSpinner, -2, 57, -2).addGap(170, 170, 170)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameDescriptionLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.positionDescriptionLabel).addComponent(this.positionSpinner, -2, -1, -2))));
    }
}

