/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalDetailPanel
extends GenericDetailPanel<Journal> {
    private JLabel conferenceInformationDescriptionLabel;
    private JTextField conferenceInformationTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel sourceDescriptionLabel;
    private JTextField sourceTextField;
    private Journal journal;

    public JournalDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addJournalObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.sourceTextField.setText("");
        this.conferenceInformationTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.sourceTextField.setEnabled(enabled);
        this.conferenceInformationTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Journal journal) {
        this.journal = journal;
        if (journal != null) {
            this.idTextField.setText(this.journal.getJournalID().toString());
            this.sourceTextField.setText(this.journal.getSource());
            this.conferenceInformationTextField.setText(this.journal.getConferenceInformation());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public void setEditable(boolean editable) {
        this.sourceTextField.setEditable(editable);
        this.conferenceInformationTextField.setEditable(editable);
    }

    public String getSource() {
        return this.sourceTextField.getText();
    }

    public String getConferenceInformation() {
        return this.conferenceInformationTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<Journal> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Journal> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.journal);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<Journal> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.sourceDescriptionLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.conferenceInformationTextField = new JTextField();
        this.conferenceInformationDescriptionLabel = new JLabel();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEditable(false);
        this.sourceDescriptionLabel.setText("Source:");
        this.conferenceInformationDescriptionLabel.setText("ISSN:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.sourceDescriptionLabel).addComponent(this.conferenceInformationDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceTextField, -1, 185, Short.MAX_VALUE).addComponent(this.conferenceInformationTextField, -1, 185, Short.MAX_VALUE).addComponent(this.idTextField, -2, 56, -2)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceDescriptionLabel).addComponent(this.sourceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.conferenceInformationDescriptionLabel).addComponent(this.conferenceInformationTextField, -2, -1, -2))));
    }
}

