/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentDetailPanel
extends GenericDetailPanel<Document> {
    private JLabel abstractDescriptionLabel;
    private JScrollPane abstractScrollPane;
    private JTextArea abstractTextArea;
    private JLabel beginPageDescriptionLabel;
    private JTextField beginPageTextField;
    private JLabel citationsDescriptionLabel;
    private JSpinner citationsSpinner;
    private JLabel doiDescriptionLabel;
    private JTextField doiTextField;
    private JLabel endPageDescriptionLabel;
    private JTextField endPageTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private JLabel issueDescriptionLabel;
    private JTextField issueTextField;
    private JLabel sourceIdentifierDescriptionLabel;
    private JTextField sourceIdentifierTextField;
    private JLabel titleDescriptionLabel;
    private JTextField titleTextField;
    private JLabel typeDescriptionLabel;
    private JTextField typeTextField;
    private JLabel volumeDescriptionLabel;
    private JTextField volumeTextField;
    private Document document;

    public DocumentDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addDocumentObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.typeTextField.setText("");
        this.titleTextField.setText("");
        this.issueTextField.setText("");
        this.volumeTextField.setText("");
        this.beginPageTextField.setText("");
        this.endPageTextField.setText("");
        this.doiTextField.setText("");
        this.abstractTextArea.setText("");
        this.citationsSpinner.setValue(0);
        this.sourceIdentifierTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.typeTextField.setEnabled(enabled);
        this.titleTextField.setEnabled(enabled);
        this.issueTextField.setEnabled(enabled);
        this.volumeTextField.setEnabled(enabled);
        this.beginPageTextField.setEnabled(enabled);
        this.endPageTextField.setEnabled(enabled);
        this.doiTextField.setEnabled(enabled);
        this.abstractTextArea.setEnabled(enabled);
        this.citationsSpinner.setEnabled(enabled);
        this.sourceIdentifierTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Document document) {
        this.document = document;
        if (document != null) {
            this.idTextField.setText(this.document.getDocumentID().toString());
            this.typeTextField.setText(this.document.getType());
            this.titleTextField.setText(this.document.getTitle());
            this.issueTextField.setText(this.document.getIssue());
            this.volumeTextField.setText(this.document.getVolume());
            this.beginPageTextField.setText(this.document.getBeginPage());
            this.endPageTextField.setText(this.document.getEndPage());
            this.doiTextField.setText(this.document.getDoi());
            this.abstractTextArea.setText(this.document.getDocAbstract());
            this.citationsSpinner.setValue(this.document.getCitationsCount());
            this.sourceIdentifierTextField.setText(this.document.getSourceIdentifier());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getType() {
        return this.typeTextField.getText();
    }

    public String getTitle() {
        return this.titleTextField.getText();
    }

    public String getIssue() {
        return this.issueTextField.getText();
    }

    public String getVolume() {
        return this.volumeTextField.getText();
    }

    public String getBeginPage() {
        return this.beginPageTextField.getText();
    }

    public String getEndPage() {
        return this.endPageTextField.getText();
    }

    public String getAbstract() {
        return this.abstractTextArea.getText();
    }

    public String getDoi() {
        return this.doiTextField.getText();
    }

    public int getCitations() {
        return (Integer)this.citationsSpinner.getValue();
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifierTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<Document> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Document> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.document);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<Document> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.typeDescriptionLabel = new JLabel();
        this.typeTextField = new JTextField();
        this.titleDescriptionLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.issueDescriptionLabel = new JLabel();
        this.issueTextField = new JTextField();
        this.volumeDescriptionLabel = new JLabel();
        this.volumeTextField = new JTextField();
        this.beginPageDescriptionLabel = new JLabel();
        this.beginPageTextField = new JTextField();
        this.endPageDescriptionLabel = new JLabel();
        this.endPageTextField = new JTextField();
        this.doiDescriptionLabel = new JLabel();
        this.doiTextField = new JTextField();
        this.abstractDescriptionLabel = new JLabel();
        this.abstractScrollPane = new JScrollPane();
        this.abstractTextArea = new JTextArea();
        this.citationsDescriptionLabel = new JLabel();
        this.sourceIdentifierDescriptionLabel = new JLabel();
        this.sourceIdentifierTextField = new JTextField();
        this.citationsSpinner = new JSpinner();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEditable(false);
        this.typeDescriptionLabel.setText("Type:");
        this.titleDescriptionLabel.setText("Title:");
        this.issueDescriptionLabel.setText("Issue:");
        this.volumeDescriptionLabel.setText("Volume:");
        this.beginPageDescriptionLabel.setText("Begin page:");
        this.endPageDescriptionLabel.setText("Begin page:");
        this.doiDescriptionLabel.setText("Doi:");
        this.abstractDescriptionLabel.setText("Abstract:");
        this.abstractTextArea.setColumns(20);
        this.abstractTextArea.setLineWrap(true);
        this.abstractTextArea.setRows(5);
        this.abstractTextArea.setWrapStyleWord(true);
        this.abstractScrollPane.setViewportView(this.abstractTextArea);
        this.citationsDescriptionLabel.setText("Citations:");
        this.sourceIdentifierDescriptionLabel.setText("Source identifier:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleDescriptionLabel).addComponent(this.issueDescriptionLabel).addComponent(this.doiDescriptionLabel).addComponent(this.abstractDescriptionLabel).addComponent(this.idDescriptionLabel)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.abstractScrollPane, -1, 300, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeTextField, -1, 188, Short.MAX_VALUE)).addComponent(this.titleTextField, -1, 300, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.issueTextField, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeTextField, -1, 26, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.beginPageDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.beginPageTextField, -1, 28, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endPageDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endPageTextField, -1, 27, Short.MAX_VALUE)).addComponent(this.doiTextField, -1, 300, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.citationsDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.citationsSpinner, -1, 80, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceIdentifierDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceIdentifierTextField, -1, 130, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2).addComponent(this.typeDescriptionLabel).addComponent(this.typeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleDescriptionLabel).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.issueDescriptionLabel).addComponent(this.issueTextField, -2, -1, -2).addComponent(this.volumeDescriptionLabel).addComponent(this.volumeTextField, -2, -1, -2).addComponent(this.beginPageDescriptionLabel).addComponent(this.beginPageTextField, -2, -1, -2).addComponent(this.endPageDescriptionLabel).addComponent(this.endPageTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doiDescriptionLabel).addComponent(this.doiTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.abstractDescriptionLabel).addComponent(this.abstractScrollPane, -1, 268, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.citationsDescriptionLabel).addComponent(this.citationsSpinner, -2, -1, -2).addComponent(this.sourceIdentifierDescriptionLabel).addComponent(this.sourceIdentifierTextField, -2, -1, -2))));
    }
}

