/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorReferenceDetailPanel
extends GenericDetailPanel<AuthorReference> {
    private JLabel authorNameDescriptionLabel;
    private JTextField authorNameTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private AuthorReference authorReference;

    public AuthorReferenceDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addAuthorReferenceObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.authorNameTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.authorNameTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(AuthorReference authorReference) {
        this.authorReference = authorReference;
        if (authorReference != null) {
            this.idTextField.setText(this.authorReference.getAuthorReferenceID().toString());
            this.authorNameTextField.setText(this.authorReference.getAuthorName());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getAuthorName() {
        return this.authorNameTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<AuthorReference> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<AuthorReference> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.authorReference);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityRemoved(ArrayList<AuthorReference> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.authorNameDescriptionLabel = new JLabel();
        this.authorNameTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEditable(false);
        this.authorNameDescriptionLabel.setText("Name:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.authorNameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 61, -2).addContainerGap(98, Short.MAX_VALUE)).addComponent(this.authorNameTextField, -1, 159, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorNameDescriptionLabel).addComponent(this.authorNameTextField, -2, -1, -2))));
    }
}

