/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorDetailPanel
extends GenericDetailPanel<Author> {
    private JLabel authorNameDescriptionLabel;
    private JTextField authorNameTextField;
    private JLabel fullAuthorNameDescriptionLabel;
    private JTextField fullAuthorNameTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private Author author;

    public AuthorDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addAuthorObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.authorNameTextField.setText("");
        this.fullAuthorNameTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.authorNameTextField.setEnabled(enabled);
        this.fullAuthorNameTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Author author) {
        this.author = author;
        if (author != null) {
            this.idTextField.setText(this.author.getAuthorID().toString());
            this.authorNameTextField.setText(this.author.getAuthorName());
            this.fullAuthorNameTextField.setText(this.author.getFullAuthorName());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getAuthorName() {
        return this.authorNameTextField.getText();
    }

    public String getFullAuthorName() {
        return this.fullAuthorNameDescriptionLabel.getText();
    }

    @Override
    public void entityUpdated(ArrayList<Author> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.author);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    @Override
    public void entityAdded(ArrayList<Author> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityRemoved(ArrayList<Author> items) throws KnowledgeBaseException {
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.authorNameDescriptionLabel = new JLabel();
        this.authorNameTextField = new JTextField();
        this.fullAuthorNameDescriptionLabel = new JLabel();
        this.fullAuthorNameTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEditable(false);
        this.authorNameDescriptionLabel.setText("Name:");
        this.fullAuthorNameDescriptionLabel.setText("Full author name:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.authorNameDescriptionLabel).addComponent(this.fullAuthorNameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 86, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.authorNameTextField).addComponent(this.fullAuthorNameTextField, GroupLayout.Alignment.LEADING, -1, 209, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorNameDescriptionLabel).addComponent(this.authorNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fullAuthorNameTextField, -2, -1, -2).addComponent(this.fullAuthorNameDescriptionLabel))));
    }
}

