/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.detailspanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.detailspanel.GenericDetailPanel;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffiliationDetailPanel
extends GenericDetailPanel<Affiliation> {
    private JLabel fullAffiliationDescriptionLabel;
    private JTextField fullAffiliationTextField;
    private JLabel idDescriptionLabel;
    private JTextField idTextField;
    private Affiliation affiliation = null;

    public AffiliationDetailPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addAffiliationObserver(this);
    }

    public void reset() {
        this.idTextField.setText("");
        this.fullAffiliationTextField.setText("");
        this.setEnableTextField(false);
    }

    public void setEnableTextField(boolean enabled) {
        this.idTextField.setEnabled(enabled);
        this.fullAffiliationTextField.setEnabled(enabled);
    }

    @Override
    public void refreshItem(Affiliation affiliation) {
        this.affiliation = affiliation;
        if (this.affiliation != null) {
            this.idTextField.setText(this.affiliation.getAffiliationID().toString());
            this.fullAffiliationTextField.setText(this.affiliation.getFullAffiliation());
            this.setEnableTextField(true);
        } else {
            this.reset();
        }
    }

    public String getFullAffiliation() {
        return this.fullAffiliationTextField.getText();
    }

    @Override
    public void entityAdded(ArrayList<Affiliation> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRemoved(ArrayList<Affiliation> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Affiliation> items) throws KnowledgeBaseException {
        int position = items.indexOf(this.affiliation);
        if (position != -1) {
            this.refreshItem(items.get(position));
        }
    }

    private void initComponents() {
        this.idDescriptionLabel = new JLabel();
        this.idTextField = new JTextField();
        this.fullAffiliationDescriptionLabel = new JLabel();
        this.fullAffiliationTextField = new JTextField();
        this.idDescriptionLabel.setText("ID:");
        this.idTextField.setEnabled(false);
        this.fullAffiliationDescriptionLabel.setText("Full affiliation:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.fullAffiliationDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.idTextField, -2, 89, -2).addContainerGap()).addComponent(this.fullAffiliationTextField, -1, 167, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idDescriptionLabel).addComponent(this.idTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fullAffiliationDescriptionLabel).addComponent(this.fullAffiliationTextField, -2, -1, -2))));
    }
}

