/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.analysisview;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.analysis.AnalysisConfiguration;
import scimat.analysis.BuildPerformanceMeasuresAvailable;
import scimat.analysis.CurrentAnalysis;
import scimat.analysis.KindOfMatrixEnum;
import scimat.analysis.PerformanceMeasuresAvailable;
import scimat.analysis.PropertyDocumentSetItem;
import scimat.api.analysis.category.StrategicDiagram;
import scimat.api.analysis.category.StrategicDiagramBuildier;
import scimat.api.mapping.Node;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.api.utils.property.PropertySet;
import scimat.gui.components.analysisview.ClusterNetworkPanel;
import scimat.gui.components.analysisview.StrategicDiagramPanel;
import scimat.gui.components.itemslist.GenericItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;
import scimat.gui.components.tablemodel.ClusterPropertiesTableModel;
import scimat.gui.components.tablemodel.ClusterTableModel;
import scimat.gui.components.tablemodel.NodeTableModel;
import scimat.gui.components.tablemodel.PerformanceMeasuresAvailableTableModel;
import scimat.gui.components.tablemodel.PeriodsInAnalysisTableModel;
import scimat.model.knowledgebase.entity.Period;

public class ResultsByPeriodPanel
extends JPanel {
    private ClusterNetworkPanel clusterNetworkPanel;
    private JPanel clusterPropertiesPanel;
    private JPanel clustersPanel;
    private JPanel nodesPanel;
    private JPanel performanceMeasuresPanel;
    private JPanel periodsPanel;
    private JPanel strategicDiagramHolderPanel;
    private StrategicDiagramPanel strategicDiagramPanel;
    private GenericItemsListPanel<Period> periodsListPanel;
    private GenericItemsListPanel<Cluster> clustersListPanel;
    private GenericItemsListPanel<PropertyDocumentSetItem> clusterPropertiesListPanel;
    private GenericItemsListPanel<PerformanceMeasuresAvailable> performanceMeasuresAvailableListPanel;
    private GenericItemsListPanel<Node> nodeListPanel;
    private double networkMaxSize = 0.0;
    private ClusterSet selectedClusterSet;
    private BuildPerformanceMeasuresAvailable buildPerformanceMeasuresAvailable = new BuildPerformanceMeasuresAvailable();
    private PerformanceMeasuresAvailable selectedMeasure = null;
    private StrategicDiagramBuildier strategicDiagramBuildier;

    public ResultsByPeriodPanel() {
        this.periodsListPanel = new GenericItemsListPanel<Period>(new PeriodsInAnalysisTableModel());
        this.clustersListPanel = new GenericItemsListPanel<Cluster>(new ClusterTableModel());
        this.clusterPropertiesListPanel = new GenericItemsListPanel<PropertyDocumentSetItem>(new ClusterPropertiesTableModel());
        this.performanceMeasuresAvailableListPanel = new GenericItemsListPanel<PerformanceMeasuresAvailable>(new PerformanceMeasuresAvailableTableModel());
        this.nodeListPanel = new GenericItemsListPanel<Node>(new NodeTableModel());
        this.initComponents();
        this.periodsPanel.add(this.periodsListPanel);
        this.clustersPanel.add(this.clustersListPanel);
        this.clusterPropertiesPanel.add(this.clusterPropertiesListPanel);
        this.performanceMeasuresPanel.add(this.performanceMeasuresAvailableListPanel);
        this.nodesPanel.add(this.nodeListPanel);
        this.periodsListPanel.addSelectionObserver(new PeriodsListPanelObserver());
        this.clustersListPanel.addSelectionObserver(new ClusterListPanelObserver());
        this.performanceMeasuresAvailableListPanel.addSelectionObserver(new PerformanceMeasuresAvailableObserver());
    }

    public void refresh() {
        this.periodsListPanel.refreshItems(CurrentAnalysis.getInstance().getResults().getAnalysisConfiguration().getPeriods());
        this.clustersListPanel.refreshItems(new ArrayList());
        this.clusterPropertiesListPanel.refreshItems(new ArrayList());
        this.performanceMeasuresAvailableListPanel.refreshItems(this.buildPerformanceMeasuresAvailable.build());
        this.strategicDiagramPanel.refreshItems(new StrategicDiagram());
        this.clusterNetworkPanel.refresh();
        this.selectedMeasure = null;
    }

    private void refreshStrategicDiagram() {
        if (this.selectedClusterSet != null) {
            if (this.selectedMeasure != null) {
                this.strategicDiagramPanel.refreshItems(this.strategicDiagramBuildier.buildStrategicDiagram(this.selectedClusterSet, this.selectedMeasure.getMapper() + this.selectedMeasure.getPropertyKey()));
            } else {
                this.strategicDiagramPanel.refreshItems(this.strategicDiagramBuildier.buildStrategicDiagram(this.selectedClusterSet, null));
            }
        }
    }

    private void initComponents() {
        this.strategicDiagramHolderPanel = new JPanel();
        this.strategicDiagramPanel = new StrategicDiagramPanel();
        this.clusterNetworkPanel = new ClusterNetworkPanel();
        this.clusterPropertiesPanel = new JPanel();
        this.clustersPanel = new JPanel();
        this.periodsPanel = new JPanel();
        this.performanceMeasuresPanel = new JPanel();
        this.nodesPanel = new JPanel();
        this.strategicDiagramHolderPanel.setBorder(BorderFactory.createTitledBorder("Strategic diagram"));
        GroupLayout strategicDiagramHolderPanelLayout = new GroupLayout(this.strategicDiagramHolderPanel);
        this.strategicDiagramHolderPanel.setLayout(strategicDiagramHolderPanelLayout);
        strategicDiagramHolderPanelLayout.setHorizontalGroup(strategicDiagramHolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.strategicDiagramPanel, -1, 412, Short.MAX_VALUE));
        strategicDiagramHolderPanelLayout.setVerticalGroup(strategicDiagramHolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.strategicDiagramPanel, -1, 385, Short.MAX_VALUE));
        this.clusterNetworkPanel.setBorder(BorderFactory.createTitledBorder("Cluster's network"));
        this.clusterPropertiesPanel.setBorder(BorderFactory.createTitledBorder("Cluster's properties"));
        this.clusterPropertiesPanel.setLayout(new BoxLayout(this.clusterPropertiesPanel, 2));
        this.clustersPanel.setBorder(BorderFactory.createTitledBorder("Clusters"));
        this.clustersPanel.setLayout(new BoxLayout(this.clustersPanel, 2));
        this.periodsPanel.setBorder(BorderFactory.createTitledBorder("Periods"));
        this.periodsPanel.setLayout(new BoxLayout(this.periodsPanel, 2));
        this.performanceMeasuresPanel.setBorder(BorderFactory.createTitledBorder("Performance measures"));
        this.performanceMeasuresPanel.setLayout(new BoxLayout(this.performanceMeasuresPanel, 2));
        this.nodesPanel.setBorder(BorderFactory.createTitledBorder("Nodes"));
        this.nodesPanel.setLayout(new BoxLayout(this.nodesPanel, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.periodsPanel, -1, 257, Short.MAX_VALUE).addComponent(this.nodesPanel, GroupLayout.Alignment.LEADING, -1, 257, Short.MAX_VALUE).addComponent(this.performanceMeasuresPanel, GroupLayout.Alignment.LEADING, -1, 257, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clustersPanel, -1, 424, Short.MAX_VALUE).addComponent(this.strategicDiagramHolderPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clusterPropertiesPanel, -1, 189, Short.MAX_VALUE).addComponent(this.clusterNetworkPanel, -1, 189, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.clustersPanel, GroupLayout.Alignment.LEADING, -1, 127, Short.MAX_VALUE).addComponent(this.clusterPropertiesPanel, -1, 127, Short.MAX_VALUE).addComponent(this.periodsPanel, GroupLayout.Alignment.LEADING, -1, 127, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clusterNetworkPanel, -1, 412, Short.MAX_VALUE).addComponent(this.strategicDiagramHolderPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.performanceMeasuresPanel, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodesPanel, -1, 137, Short.MAX_VALUE)))));
    }

    private class PerformanceMeasuresAvailableObserver
    implements SelectionObserver {
        private PerformanceMeasuresAvailableObserver() {
        }

        public void selectionChangeHappened(int[] selection) {
            if (selection.length == 1) {
                ResultsByPeriodPanel.this.selectedMeasure = (PerformanceMeasuresAvailable)ResultsByPeriodPanel.this.performanceMeasuresAvailableListPanel.getItem(selection[0]);
                ResultsByPeriodPanel.this.refreshStrategicDiagram();
            } else {
                ResultsByPeriodPanel.this.selectedMeasure = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterListPanelObserver
    implements SelectionObserver {
        private ClusterListPanelObserver() {
        }

        @Override
        public void selectionChangeHappened(int[] selection) {
            if (selection.length == 1) {
                ResultsByPeriodPanel.this.clusterPropertiesListPanel.refreshItems(this.buildClusterProperties((Cluster)ResultsByPeriodPanel.this.clustersListPanel.getItem(selection[0])));
                ResultsByPeriodPanel.this.clusterNetworkPanel.refreshData((Cluster)ResultsByPeriodPanel.this.clustersListPanel.getItem(selection[0]), ResultsByPeriodPanel.this.selectedClusterSet.getWholeNetwork(), ResultsByPeriodPanel.this.networkMaxSize);
                ArrayList<Node> nodes = new ArrayList<Node>();
                ArrayList<Integer> nodesIDs = ((Cluster)ResultsByPeriodPanel.this.clustersListPanel.getItem(selection[0])).getNodes();
                for (int i = 0; i < nodesIDs.size(); ++i) {
                    nodes.add(ResultsByPeriodPanel.this.selectedClusterSet.getWholeNetwork().getNode(nodesIDs.get(i)));
                }
                ResultsByPeriodPanel.this.nodeListPanel.refreshItems(nodes);
            } else {
                ResultsByPeriodPanel.this.clusterPropertiesListPanel.refreshItems(new ArrayList());
            }
        }

        private ArrayList<PropertyDocumentSetItem> buildClusterProperties(Cluster cluster) {
            ArrayList<PropertyDocumentSetItem> properties = new ArrayList<PropertyDocumentSetItem>();
            AnalysisConfiguration conf = CurrentAnalysis.getInstance().getResults().getAnalysisConfiguration();
            if (conf.getKindOfMatrix().equals(KindOfMatrixEnum.CoOccurrence) || conf.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnAuthor) || conf.getKindOfMatrix().equals(KindOfMatrixEnum.AggregatedCouplingBasedOnJournal)) {
                if (conf.isCoreMapper()) {
                    this.addDocumentMapperProperties(conf, properties, "coreDocuments", cluster.getProperties());
                }
                if (conf.isSecondaryMapper()) {
                    this.addDocumentMapperProperties(conf, properties, "secondaryDocuments", cluster.getProperties());
                }
                if (conf.iskCoreMapper()) {
                    this.addDocumentMapperProperties(conf, properties, "kCoreDocuments", cluster.getProperties());
                }
                if (conf.isIntersectionMapper()) {
                    this.addDocumentMapperProperties(conf, properties, "intersectionDocument", cluster.getProperties());
                }
                if (conf.isUnionMapper()) {
                    this.addDocumentMapperProperties(conf, properties, "unionDocuments", cluster.getProperties());
                }
            } else if (conf.isBasicCouplingMapper()) {
                this.addDocumentMapperProperties(conf, properties, "couplingDocuments", cluster.getProperties());
            }
            return properties;
        }

        private void addDocumentMapperProperties(AnalysisConfiguration conf, ArrayList<PropertyDocumentSetItem> properties, String mapper, PropertySet propertySet) {
            properties.add(new PropertyDocumentSetItem(mapper, "documentsCount", (Double)propertySet.getProperty(mapper + "documentsCount").getValue()));
            if (conf.isHIndex()) {
                properties.add(new PropertyDocumentSetItem(mapper, "hIndex", (Double)propertySet.getProperty(mapper + "hIndex").getValue()));
            }
            if (conf.isGIndex()) {
                properties.add(new PropertyDocumentSetItem(mapper, "gIndex", (Double)propertySet.getProperty(mapper + "gIndex").getValue()));
            }
            if (conf.isHgIndex()) {
                properties.add(new PropertyDocumentSetItem(mapper, "hgIndex", (Double)propertySet.getProperty(mapper + "hgIndex").getValue()));
            }
            if (conf.isQ2Index()) {
                properties.add(new PropertyDocumentSetItem(mapper, "q2Index", (Double)propertySet.getProperty(mapper + "q2Index").getValue()));
            }
            if (conf.isAverageCitations()) {
                properties.add(new PropertyDocumentSetItem(mapper, "averageCitations", (Double)propertySet.getProperty(mapper + "averageCitations").getValue()));
            }
            if (conf.isSumCitations()) {
                properties.add(new PropertyDocumentSetItem(mapper, "sumCitations", (Double)propertySet.getProperty(mapper + "sumCitations").getValue()));
            }
            if (conf.isMaxCitations()) {
                properties.add(new PropertyDocumentSetItem(mapper, "maxCitations", (Double)propertySet.getProperty(mapper + "maxCitations").getValue()));
            }
            if (conf.isMinCitations()) {
                properties.add(new PropertyDocumentSetItem(mapper, "minCitations", (Double)propertySet.getProperty(mapper + "minCitations").getValue()));
            }
        }
    }

    private class PeriodsListPanelObserver
    implements SelectionObserver {
        public PeriodsListPanelObserver() {
            ResultsByPeriodPanel.this.strategicDiagramBuildier = new StrategicDiagramBuildier("callonCentralityRange", "callonDensityRange", "clusterName");
        }

        public void selectionChangeHappened(int[] selection) {
            if (selection.length == 1) {
                ResultsByPeriodPanel.this.clustersListPanel.refreshItems(CurrentAnalysis.getInstance().getResults().getAnalysisPeriodResult(selection[0]).getClusterSet().getClusters());
                ResultsByPeriodPanel.this.clusterPropertiesListPanel.refreshItems(new ArrayList());
                ResultsByPeriodPanel.this.selectedClusterSet = CurrentAnalysis.getInstance().getResults().getAnalysisPeriodResult(selection[0]).getClusterSet();
                ResultsByPeriodPanel.this.refreshStrategicDiagram();
                ResultsByPeriodPanel.this.networkMaxSize = 0.0;
                ArrayList<Node> nodes = ResultsByPeriodPanel.this.selectedClusterSet.getWholeNetwork().getNodes();
                for (int i = 0; i < nodes.size(); ++i) {
                    double tmp = (Double)nodes.get(i).getProperties().getProperty("nodeFrequency").getValue();
                    if (!(tmp > ResultsByPeriodPanel.this.networkMaxSize)) continue;
                    ResultsByPeriodPanel.this.networkMaxSize = tmp;
                }
            } else {
                ResultsByPeriodPanel.this.clustersListPanel.refreshItems(new ArrayList());
                ResultsByPeriodPanel.this.clusterPropertiesListPanel.refreshItems(new ArrayList());
                ResultsByPeriodPanel.this.strategicDiagramPanel.refreshItems(new StrategicDiagram());
            }
        }
    }
}

