/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.analysisview;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.analysis.BuildPerformanceMeasuresAvailable;
import scimat.analysis.CurrentAnalysis;
import scimat.analysis.PerformanceMeasuresAvailable;
import scimat.api.mapping.clustering.result.ClusterSet;
import scimat.gui.components.HideAndShowPanel;
import scimat.gui.components.analysisview.EvolutionMapPanel;
import scimat.gui.components.analysisview.OverlappingMapPanel;
import scimat.gui.components.itemslist.GenericItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;
import scimat.gui.components.tablemodel.PerformanceMeasuresAvailableTableModel;

public class LongitudinalResultPanel
extends JPanel {
    private JPanel downPanel;
    private EvolutionMapPanel evolutionMapPanel;
    private HideAndShowPanel hideAndShowEvolutionMapPanel;
    private HideAndShowPanel hideAndShowOverlappinMapPanel;
    private OverlappingMapPanel overlappingMapPanel;
    private JPanel performanceMeasuresPanel;
    private GenericItemsListPanel<PerformanceMeasuresAvailable> performanceMeasuresAvailableListPanel;
    private BuildPerformanceMeasuresAvailable buildPerformanceMeasuresAvailable = new BuildPerformanceMeasuresAvailable();
    private PerformanceMeasuresAvailable selectedMeasure = null;
    private ArrayList<ClusterSet> clusterSets;

    public LongitudinalResultPanel() {
        this.performanceMeasuresAvailableListPanel = new GenericItemsListPanel<PerformanceMeasuresAvailable>(new PerformanceMeasuresAvailableTableModel());
        this.initComponents();
        this.performanceMeasuresPanel.add(this.performanceMeasuresAvailableListPanel);
        this.performanceMeasuresAvailableListPanel.addSelectionObserver(new PerformanceMeasuresAvailableObserver());
    }

    public void refresh() {
        this.clusterSets = new ArrayList();
        for (int i = 0; i < CurrentAnalysis.getInstance().getResults().getAnalysisPeriodResultsCount(); ++i) {
            this.clusterSets.add(CurrentAnalysis.getInstance().getResults().getAnalysisPeriodResult(i).getClusterSet());
        }
        this.overlappingMapPanel.refreshItems(CurrentAnalysis.getInstance().getResults().getLongitudinalResult().getOverlappingMap());
        this.performanceMeasuresAvailableListPanel.refreshItems(this.buildPerformanceMeasuresAvailable.build());
        this.refreshEvolutionMap();
    }

    public void refreshEvolutionMap() {
        if (this.selectedMeasure != null) {
            this.evolutionMapPanel.refreshItems(this.clusterSets, CurrentAnalysis.getInstance().getResults().getLongitudinalResult().getEvolutionMap(), this.selectedMeasure.getMapper() + this.selectedMeasure.getPropertyKey(), "clusterName");
        } else {
            this.evolutionMapPanel.refreshItems(this.clusterSets, CurrentAnalysis.getInstance().getResults().getLongitudinalResult().getEvolutionMap(), null, "clusterName");
        }
    }

    private void initComponents() {
        this.overlappingMapPanel = new OverlappingMapPanel();
        this.hideAndShowOverlappinMapPanel = new HideAndShowPanel();
        this.hideAndShowEvolutionMapPanel = new HideAndShowPanel();
        this.downPanel = new JPanel();
        this.performanceMeasuresPanel = new JPanel();
        this.evolutionMapPanel = new EvolutionMapPanel();
        this.hideAndShowOverlappinMapPanel.setDescription("Overlapping map");
        this.hideAndShowOverlappinMapPanel.setPanel(this.overlappingMapPanel);
        this.hideAndShowEvolutionMapPanel.setDescription("Evolution map");
        this.hideAndShowEvolutionMapPanel.setPanel(this.downPanel);
        this.performanceMeasuresPanel.setBorder(BorderFactory.createTitledBorder("Performance measures"));
        this.performanceMeasuresPanel.setLayout(new BoxLayout(this.performanceMeasuresPanel, 2));
        GroupLayout downPanelLayout = new GroupLayout(this.downPanel);
        this.downPanel.setLayout(downPanelLayout);
        downPanelLayout.setHorizontalGroup(downPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downPanelLayout.createSequentialGroup().addComponent(this.performanceMeasuresPanel, -2, 169, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.evolutionMapPanel, -1, 497, Short.MAX_VALUE)));
        downPanelLayout.setVerticalGroup(downPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.evolutionMapPanel, -1, 198, Short.MAX_VALUE).addComponent(this.performanceMeasuresPanel, -1, 198, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hideAndShowOverlappinMapPanel, -1, 672, Short.MAX_VALUE).addComponent(this.overlappingMapPanel, -1, 672, Short.MAX_VALUE).addComponent(this.hideAndShowEvolutionMapPanel, -1, 672, Short.MAX_VALUE).addComponent(this.downPanel, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hideAndShowOverlappinMapPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingMapPanel, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideAndShowEvolutionMapPanel, -2, -1, -2).addGap(6, 6, 6).addComponent(this.downPanel, -2, -1, Short.MAX_VALUE)));
    }

    private class PerformanceMeasuresAvailableObserver
    implements SelectionObserver {
        private PerformanceMeasuresAvailableObserver() {
        }

        public void selectionChangeHappened(int[] selection) {
            if (selection.length == 1) {
                LongitudinalResultPanel.this.selectedMeasure = (PerformanceMeasuresAvailable)LongitudinalResultPanel.this.performanceMeasuresAvailableListPanel.getItem(selection[0]);
                LongitudinalResultPanel.this.refreshEvolutionMap();
            } else {
                LongitudinalResultPanel.this.selectedMeasure = null;
            }
        }
    }
}

