/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.analysisview;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.w3c.dom.Document;
import scimat.api.mapping.WholeNetwork;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.visualization.graph.ClusterNetworkSVG;

public class ClusterNetworkPanel
extends JPanel {
    private JSVGCanvas svgCanvas = new JSVGCanvas();
    private JSVGScrollPane svgScrollPane = new JSVGScrollPane(this.svgCanvas);
    private Document document;
    private ClusterNetworkSVG clusterNetworkSVG = new ClusterNetworkSVG(400, 50, 10, 10);

    public ClusterNetworkPanel() {
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ClusterNetworkPanel.this.svgCanvas.setDocument(ClusterNetworkPanel.this.document);
            }
        });
        this.document = this.clusterNetworkSVG.buildEmptyXML();
        this.svgCanvas.setDocument(this.document);
        this.svgCanvas.setDocumentState(1);
        this.add((Component)this.svgScrollPane);
    }

    public void refresh() {
        this.svgCanvas.setDocument(null);
        this.svgCanvas.validate();
    }

    public void refreshData(Cluster cluster, WholeNetwork wholeNetwork, double maxSize) {
        this.document = this.clusterNetworkSVG.buildXML(cluster, wholeNetwork, "nodeFrequency", "nodeName", maxSize);
        this.svgCanvas.setDocument(this.document);
        this.svgCanvas.validate();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 2));
    }
}

