/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.analysisview;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import scimat.analysis.CurrentAnalysis;
import scimat.gui.commands.task.MakeAdvancedReportHTMLTask;
import scimat.gui.commands.task.MakeAdvancedReportLaTeXTask;
import scimat.gui.commands.task.MakeReportHTMLTask;
import scimat.gui.commands.task.MakeReportLaTeXTask;
import scimat.gui.components.analysisview.LongitudinalResultPanel;
import scimat.gui.components.analysisview.ResultsByPeriodPanel;

public class AnalysisViewDialog
extends JDialog {
    private JMenuItem exitMenuItem;
    private JMenuItem exportHTMLMenuItem;
    private JMenuItem exportLatexMenuItem;
    private JMenuItem exportToFullHTMLMenuItem;
    private JMenuItem exportToFullLaTexMenuItem;
    private JMenu fileMenu;
    private LongitudinalResultPanel longitudinalResultPanel;
    private JTabbedPane mainTabbedPane;
    private JMenuBar menuBar;
    private ResultsByPeriodPanel resultsByPeriodPanel;
    private JPopupMenu.Separator separator;

    public AnalysisViewDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void refresh() {
        this.longitudinalResultPanel.refresh();
        this.resultsByPeriodPanel.refresh();
    }

    private void initComponents() {
        this.mainTabbedPane = new JTabbedPane();
        this.longitudinalResultPanel = new LongitudinalResultPanel();
        this.resultsByPeriodPanel = new ResultsByPeriodPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exportHTMLMenuItem = new JMenuItem();
        this.exportToFullHTMLMenuItem = new JMenuItem();
        this.exportLatexMenuItem = new JMenuItem();
        this.exportToFullLaTexMenuItem = new JMenuItem();
        this.separator = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("SciMAT 1.1 - Analysis view");
        this.mainTabbedPane.addTab("Longitudinal view", this.longitudinalResultPanel);
        this.mainTabbedPane.addTab("Period view", this.resultsByPeriodPanel);
        this.fileMenu.setText("File");
        this.exportHTMLMenuItem.setText("Export to HTML");
        this.exportHTMLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisViewDialog.this.exportHTMLMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportHTMLMenuItem);
        this.exportToFullHTMLMenuItem.setText("Export to HTML (full)");
        this.exportToFullHTMLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisViewDialog.this.exportToFullHTMLMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportToFullHTMLMenuItem);
        this.exportLatexMenuItem.setText("Export to LaTeX");
        this.exportLatexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisViewDialog.this.exportLatexMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportLatexMenuItem);
        this.exportToFullLaTexMenuItem.setText("Export to HTML (full)");
        this.exportToFullLaTexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisViewDialog.this.exportToFullLaTexMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportToFullLaTexMenuItem);
        this.fileMenu.add(this.separator);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisViewDialog.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainTabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainTabbedPane, -1, 678, Short.MAX_VALUE));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void exportHTMLMenuItemActionPerformed(ActionEvent evt) {
        new MakeReportHTMLTask(this.rootPane, CurrentAnalysis.getInstance().getResults()).execute();
    }

    private void exportLatexMenuItemActionPerformed(ActionEvent evt) {
        new MakeReportLaTeXTask(this.rootPane, CurrentAnalysis.getInstance().getResults()).execute();
    }

    private void exportToFullHTMLMenuItemActionPerformed(ActionEvent evt) {
        new MakeAdvancedReportHTMLTask(this.rootPane, CurrentAnalysis.getInstance().getResults()).execute();
    }

    private void exportToFullLaTexMenuItemActionPerformed(ActionEvent evt) {
        new MakeAdvancedReportLaTeXTask(this.rootPane, CurrentAnalysis.getInstance().getResults()).execute();
    }
}

