/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.adddialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import scimat.gui.components.itemslist.GenericSelectManyItemsPanel;
import scimat.gui.components.observer.ElementsCountObserver;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.observer.EntityObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericAddItemsDialog<M extends Comparable<M>, I extends Comparable<I>>
extends JDialog
implements ElementsCountObserver,
EntityObserver<I> {
    private JButton addButton;
    private JButton cancelButton;
    private JPanel itemsPanel;
    private JButton newItemButton;
    private JSeparator separator;
    private M masterItem;
    private GenericSelectManyItemsPanel<I> manyToManyPanel;

    public GenericAddItemsDialog(Frame parent, GenericSelectManyItemsPanel<I> manyToManyPanel) {
        super(parent, true);
        this.manyToManyPanel = manyToManyPanel;
        this.initComponents();
        this.itemsPanel.add(this.manyToManyPanel);
        this.manyToManyPanel.addTargetElementsCountObserver(this);
    }

    public void reset() {
        this.masterItem = null;
        this.addButton.setEnabled(false);
        this.manyToManyPanel.refreshData(new ArrayList());
    }

    public void refreshData(M masterItem, ArrayList<I> items) {
        this.masterItem = masterItem;
        this.manyToManyPanel.refreshData(items);
        this.addButton.setEnabled(false);
    }

    public abstract void addAction(M var1, ArrayList<I> var2);

    public abstract void addNewItemAction();

    public abstract void setEntityObserver(boolean var1);

    @Override
    public void entityAdded(ArrayList<I> items) throws KnowledgeBaseException {
        this.manyToManyPanel.addNewTargetItems(items);
    }

    @Override
    public void entityUpdated(ArrayList<I> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityRemoved(ArrayList<I> items) throws KnowledgeBaseException {
    }

    @Override
    public void elementsCountChanged(int newElementsCount) {
        this.addButton.setEnabled(newElementsCount > 0);
    }

    private void initComponents() {
        this.itemsPanel = new JPanel();
        this.separator = new JSeparator();
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.newItemButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                GenericAddItemsDialog.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                GenericAddItemsDialog.this.formWindowClosed(evt);
            }
        });
        this.itemsPanel.setLayout(new BoxLayout(this.itemsPanel, 2));
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Add the selected items");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericAddItemsDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel the action");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericAddItemsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.newItemButton.setIcon(new ImageIcon(this.getClass().getResource("/images/add-icon-16x16.png")));
        this.newItemButton.setToolTipText("New item");
        this.newItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericAddItemsDialog.this.newItemButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 380, Short.MAX_VALUE).addComponent(this.itemsPanel, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.newItemButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 209, Short.MAX_VALUE).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.itemsPanel, -1, 173, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.cancelButton)).addComponent(this.newItemButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addAction(this.masterItem, this.manyToManyPanel.getTargetItems());
    }

    private void newItemButtonActionPerformed(ActionEvent evt) {
        this.addNewItemAction();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.setEntityObserver(false);
    }

    private void formWindowActivated(WindowEvent evt) {
        this.setEntityObserver(true);
    }
}

