/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.adddialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import scimat.gui.components.itemslist.GenericSelectOneItemPanel;
import scimat.gui.components.observer.TargetItemSelectedObserver;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.observer.EntityObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericAddItemDialog<M extends Comparable<M>, I extends Comparable<I>>
extends JDialog
implements TargetItemSelectedObserver,
EntityObserver<I> {
    private JButton cancelButton;
    private JPanel itemsPanel;
    private JButton newItemButton;
    private JSeparator separator;
    private JButton setButton;
    private M masterItem;
    private GenericSelectOneItemPanel<I> oneItemPanel;

    public GenericAddItemDialog(Frame parent, GenericSelectOneItemPanel<I> genericSelectOneItemPanel) {
        super(parent, true);
        this.oneItemPanel = genericSelectOneItemPanel;
        this.initComponents();
        this.itemsPanel.add(this.oneItemPanel);
        this.oneItemPanel.addTargetItemSelectedObserver(this);
    }

    public void reset() {
        this.masterItem = null;
        this.setButton.setEnabled(false);
        this.oneItemPanel.refreshSourceItems(new ArrayList());
    }

    public void refreshData(M masterItem, ArrayList<I> items) {
        this.masterItem = masterItem;
        this.oneItemPanel.refreshSourceItems(items);
        this.setButton.setEnabled(false);
    }

    public abstract void addAction(M var1, I var2);

    public abstract void addNewItemAction();

    public abstract void setEntityObserver(boolean var1);

    @Override
    public void entityAdded(ArrayList<I> items) throws KnowledgeBaseException {
        this.oneItemPanel.addNewSourceItem(items);
    }

    @Override
    public void entityUpdated(ArrayList<I> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
    }

    @Override
    public void entityRemoved(ArrayList<I> items) throws KnowledgeBaseException {
    }

    @Override
    public void targetItemSelectionChanged(boolean selected) {
        this.setButton.setEnabled(selected);
    }

    private void initComponents() {
        this.itemsPanel = new JPanel();
        this.separator = new JSeparator();
        this.setButton = new JButton();
        this.cancelButton = new JButton();
        this.newItemButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                GenericAddItemDialog.this.formWindowActivated(evt);
            }

            public void windowClosed(WindowEvent evt) {
                GenericAddItemDialog.this.formWindowClosed(evt);
            }
        });
        this.itemsPanel.setLayout(new BoxLayout(this.itemsPanel, 2));
        this.setButton.setText("Set");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericAddItemDialog.this.setButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericAddItemDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.newItemButton.setIcon(new ImageIcon(this.getClass().getResource("/images/add-icon-16x16.png")));
        this.newItemButton.setToolTipText("New item");
        this.newItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericAddItemDialog.this.newItemButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 380, Short.MAX_VALUE).addComponent(this.itemsPanel, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.newItemButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 211, Short.MAX_VALUE).addComponent(this.setButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.itemsPanel, -1, 173, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setButton).addComponent(this.cancelButton)).addComponent(this.newItemButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        this.addAction(this.masterItem, this.oneItemPanel.getSelectedItem());
    }

    private void newItemButtonActionPerformed(ActionEvent evt) {
        this.addNewItemAction();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.setEntityObserver(false);
    }

    private void formWindowActivated(WindowEvent evt) {
        this.setEntityObserver(true);
    }
}

