/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.adddialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.add.AddPublishDateEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;

public class AddPublishDateDialog
extends JDialog {
    private JButton addButton;
    private JButton cancelButton;
    private JLabel dateDescriptionLabel;
    private JTextField dateTextField;
    private JSeparator separator;
    private JLabel yearDescriptionLabel;
    private JTextField yearTextField;

    public AddPublishDateDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    public void refresh() {
        this.yearTextField.setText("");
        this.dateTextField.setText("");
    }

    private void initComponents() {
        this.yearDescriptionLabel = new JLabel();
        this.yearTextField = new JTextField();
        this.dateTextField = new JTextField();
        this.dateDescriptionLabel = new JLabel();
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.separator = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add document");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.yearDescriptionLabel.setText("Year:");
        this.dateDescriptionLabel.setText("Date:");
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPublishDateDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddPublishDateDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.separator, GroupLayout.Alignment.LEADING, -1, 221, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateDescriptionLabel).addComponent(this.yearDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.yearTextField, -1, 190, Short.MAX_VALUE).addComponent(this.dateTextField, -1, 190, Short.MAX_VALUE)))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(109, Short.MAX_VALUE).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.yearDescriptionLabel).addComponent(this.yearTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dateDescriptionLabel).addComponent(this.dateTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.addButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.yearTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a year.\nPlease, give a year for the publish date.", "Invalid year", 0);
        } else if (this.dateTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a date.\nPlease, give a date for the publish date.", "Invalid date", 0);
        } else {
            PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new AddPublishDateEdit(this.yearTextField.getText(), this.dateTextField.getText()), this.rootPane);
            task.execute();
            if (task.isSuccessful()) {
                this.dispose();
            }
        }
    }
}

