/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.adddialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.commands.edit.add.AddAuthorEdit;
import scimat.gui.commands.task.PerformKnowledgeBaseEditTask;

public class AddAuthorDialog
extends JDialog {
    private JButton addButton;
    private JLabel authorNameDescriptionLabel;
    private JTextField authorNameTextField;
    private JButton cancelButton;
    private JLabel fullAuthorNameDescriptionLabel;
    private JTextField fullAuthorNameTextField;
    private JSeparator jSeparator1;

    public AddAuthorDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    public void refresh() {
        this.authorNameTextField.setText("");
        this.fullAuthorNameTextField.setText("");
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.authorNameDescriptionLabel = new JLabel();
        this.authorNameTextField = new JTextField();
        this.fullAuthorNameTextField = new JTextField();
        this.fullAuthorNameDescriptionLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add document");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddAuthorDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddAuthorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.authorNameDescriptionLabel.setText("Name:");
        this.fullAuthorNameDescriptionLabel.setText("Full author name:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorNameDescriptionLabel).addComponent(this.fullAuthorNameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorNameTextField, -1, 292, Short.MAX_VALUE).addComponent(this.fullAuthorNameTextField, -1, 292, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorNameDescriptionLabel).addComponent(this.authorNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fullAuthorNameTextField, -2, -1, -2).addComponent(this.fullAuthorNameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.addButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.authorNameTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a name.\nPlease, give a name for the author.", "Invalid author name", 0);
        } else if (this.fullAuthorNameTextField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You have to give a full name.\nPlease, give a full name for the author.", "Invalid full author name", 0);
        } else {
            PerformKnowledgeBaseEditTask task = new PerformKnowledgeBaseEditTask(new AddAuthorEdit(this.authorNameTextField.getText(), this.fullAuthorNameTextField.getText()), this.rootPane);
            task.execute();
            if (task.isSuccessful()) {
                this.dispose();
            }
        }
    }
}

