/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components;

import javax.swing.JButton;
import scimat.gui.components.observer.SelectionObserver;

public class SelectionObserverButton
extends JButton
implements SelectionObserver {
    private int _minThreshold;
    private int _maxThreshold;

    public SelectionObserverButton() {
        super("Button");
        this._minThreshold = -1;
        this._maxThreshold = -1;
    }

    public SelectionObserverButton(int minThreshold, int maxThreshold) {
        if (minThreshold >= 0 && maxThreshold >= 0) {
            if (minThreshold <= maxThreshold) {
                this._minThreshold = minThreshold;
                this._maxThreshold = maxThreshold;
            } else {
                this._minThreshold = this._maxThreshold = minThreshold;
            }
        } else {
            this._minThreshold = minThreshold;
            this._maxThreshold = maxThreshold;
        }
    }

    public void selectionChangeHappened(int[] selection) {
        boolean enabled = false;
        if (selection != null) {
            enabled = selection.length >= this._minThreshold;
            enabled = this._maxThreshold < 0 || selection.length <= this._maxThreshold ? enabled : false;
        } else {
            enabled = false;
        }
        this.setEnabled(enabled);
    }
}

