/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ChooseCharDelimiterDialog
extends JDialog {
    private JButton acceptButton;
    private JLabel charDelimiterLabel;
    private JTextField charDelimiterTextField;
    private JPanel errorPanel;
    private JLabel messageErrorLabel;
    private JSeparator separator;
    private char charDelimiter = (char)44;

    public ChooseCharDelimiterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.charDelimiterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ChooseCharDelimiterDialog.this.checkFindText();
            }

            public void removeUpdate(DocumentEvent e) {
                ChooseCharDelimiterDialog.this.checkFindText();
            }

            public void changedUpdate(DocumentEvent e) {
                ChooseCharDelimiterDialog.this.checkFindText();
            }
        });
    }

    public void checkFindText() {
        boolean valid;
        String message;
        String fullDelimiter = this.charDelimiterTextField.getText();
        if (fullDelimiter.isEmpty()) {
            message = "You must provide a char delimiter.";
            valid = false;
        } else if (fullDelimiter.length() > 1) {
            message = "You must provide only a char delimiter.";
            valid = false;
        } else {
            message = "";
            valid = true;
        }
        if (!valid) {
            this.messageErrorLabel.setText(message);
            this.messageErrorLabel.setForeground(Color.RED);
        } else {
            this.messageErrorLabel.setText("Correct arguments!");
            this.messageErrorLabel.setForeground(new Color(0, 99, 0));
        }
        this.acceptButton.setEnabled(valid);
    }

    public char getCharDelimiter() {
        return this.charDelimiterTextField.getText().charAt(0);
    }

    private void initComponents() {
        this.charDelimiterLabel = new JLabel();
        this.charDelimiterTextField = new JTextField();
        this.separator = new JSeparator();
        this.acceptButton = new JButton();
        this.errorPanel = new JPanel();
        this.messageErrorLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.charDelimiterLabel.setText("Char delimiter:");
        this.charDelimiterTextField.setText(";");
        this.acceptButton.setText("Accept");
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseCharDelimiterDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        GroupLayout errorPanelLayout = new GroupLayout(this.errorPanel);
        this.errorPanel.setLayout(errorPanelLayout);
        errorPanelLayout.setHorizontalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(errorPanelLayout.createSequentialGroup().addComponent(this.messageErrorLabel).addContainerGap(99, Short.MAX_VALUE)));
        errorPanelLayout.setVerticalGroup(errorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageErrorLabel));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.acceptButton, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.charDelimiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.charDelimiterTextField, -1, 25, Short.MAX_VALUE)).addComponent(this.separator, -1, 99, Short.MAX_VALUE).addComponent(this.errorPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charDelimiterLabel).addComponent(this.charDelimiterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorPanel, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acceptButton).addContainerGap()));
        this.pack();
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        this.charDelimiter = this.getCharDelimiter();
        this.dispose();
    }
}

