/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.model.upgrade.UpgradeKnowledgeBaseVersion;
import scimat.project.CurrentProject;

public class UpgradeKnowledgeBaseTask
implements NoUndoableTask {
    private String oldKnowledgeBasePath;
    private String newKnowledgeBaseFolderPath;
    private String newKnowledgeBaseFile;
    private JComponent receiver;

    public UpgradeKnowledgeBaseTask(String oldKnowledgeBasePath, String newKnowledgeBaseFolderPath, String newKnowledgeBaseFile, JComponent receiver) {
        this.oldKnowledgeBasePath = oldKnowledgeBasePath;
        this.newKnowledgeBaseFolderPath = newKnowledgeBaseFolderPath;
        this.newKnowledgeBaseFile = newKnowledgeBaseFile;
        this.receiver = receiver;
    }

    public void execute() {
        boolean flag = true;
        String fullPath = this.newKnowledgeBaseFolderPath + File.separator + this.newKnowledgeBaseFile;
        File file = new File(fullPath);
        if (file.exists()) {
            int returnVal = JOptionPane.showConfirmDialog(this.receiver, "The file already exist. Would you like to override it?", "Existing file", 1, 2);
            flag = returnVal == 0;
        }
        if (flag) {
            try {
                CursorManager.getInstance().setWaitCursor();
                new UpgradeKnowledgeBaseVersion(fullPath, this.oldKnowledgeBasePath).execute();
                CurrentProject.getInstance().loadProyect(fullPath);
                CursorManager.getInstance().setNormalCursor();
            }
            catch (KnowledgeBaseException e) {
                ErrorDialogManager.getInstance().showException(e);
            }
        }
    }
}

