/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import scimat.analysis.CurrentAnalysis;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class SaveAnalysisTask
implements NoUndoableTask {
    private JComponent receiver;

    public SaveAnalysisTask(JComponent component) {
        this.receiver = component;
    }

    public void execute() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showSaveDialog(this.receiver);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            CursorManager.getInstance().setWaitCursor();
            try {
                CurrentAnalysis.getInstance().saveResults(path);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this.receiver, "The file's format is incorrect.\nAn error happened.\nPlease choose other file.", "Error", 0);
            }
            CursorManager.getInstance().setNormalCursor();
        }
    }
}

