/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import javax.swing.JComponent;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

public class PerformKnowledgeBaseEditTask {
    private KnowledgeBaseEdit edit;
    private JComponent component;
    private boolean successful;

    public PerformKnowledgeBaseEditTask(KnowledgeBaseEdit edit, JComponent compenent) {
        this.edit = edit;
        this.component = compenent;
        this.successful = false;
    }

    public void execute() {
        try {
            CursorManager.getInstance().setWaitCursor();
            this.successful = this.edit.execute();
            CursorManager.getInstance().setNormalCursor();
            if (!this.successful) {
                ErrorDialogManager.getInstance().showError(this.edit.getErrorMessage());
            }
        }
        catch (KnowledgeBaseException e) {
            this.successful = false;
            ErrorDialogManager.getInstance().showException(e);
            e.printStackTrace(System.err);
        }
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

