/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class NewProjectTask
implements NoUndoableTask {
    private String folderPath;
    private String filePath;
    private JComponent component;

    public NewProjectTask(String folderPath, String filePath, JComponent component) {
        this.folderPath = folderPath;
        this.filePath = filePath;
        this.component = component;
    }

    public void execute() {
        boolean flag = true;
        File file = new File(this.filePath);
        if (file.exists()) {
            int returnVal = JOptionPane.showConfirmDialog(this.component, "The file already exist. Would you like to override it?", "Existing file", 1, 2);
            flag = returnVal == 0;
        }
        if (flag) {
            try {
                CursorManager.getInstance().setWaitCursor();
                CurrentProject.getInstance().newProyect(this.folderPath, this.filePath);
                CursorManager.getInstance().setNormalCursor();
            }
            catch (KnowledgeBaseException e) {
                ErrorDialogManager.getInstance().showException(e);
            }
        }
    }
}

