/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import scimat.analysis.GlobalAnalysisResult;
import scimat.api.report.MakeReportHTML;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class MakeReportHTMLTask
implements NoUndoableTask {
    private JComponent component;
    private GlobalAnalysisResult globalExperimentResult;

    public MakeReportHTMLTask(JComponent component, GlobalAnalysisResult globalExperimentResult) {
        this.component = component;
        this.globalExperimentResult = globalExperimentResult;
    }

    public void execute() {
        int returnVal;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select a directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        if (CurrentProject.getInstance().getCurrentProjectPath() != null) {
            fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
        }
        if ((returnVal = fileChooser.showSaveDialog(this.component)) == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                CursorManager.getInstance().setWaitCursor();
                new MakeReportHTML(path, this.globalExperimentResult).execute();
                CursorManager.getInstance().setNormalCursor();
            }
            catch (Exception e) {
                ErrorDialogManager.getInstance().showException(e);
            }
        }
    }
}

