/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import scimat.analysis.GlobalAnalysisResult;
import scimat.api.report.MakeExtendedReportLaTeX;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class MakeAdvancedReportLaTeXTask
implements NoUndoableTask {
    private JComponent component;
    private GlobalAnalysisResult globalExperimentResult;

    public MakeAdvancedReportLaTeXTask(JComponent component, GlobalAnalysisResult globalExperimentResult) {
        this.component = component;
        this.globalExperimentResult = globalExperimentResult;
    }

    public void execute() {
        if (CurrentProject.getInstance().isKnowledbaseLoaded()) {
            int returnVal;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Select a directory");
            fileChooser.setFileSelectionMode(1);
            fileChooser.setMultiSelectionEnabled(false);
            if (CurrentProject.getInstance().getCurrentProjectPath() != null) {
                fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
            }
            if ((returnVal = fileChooser.showSaveDialog(this.component)) == 0) {
                String path = fileChooser.getSelectedFile().getAbsolutePath();
                try {
                    CursorManager.getInstance().setWaitCursor();
                    new MakeExtendedReportLaTeX(path, this.globalExperimentResult, CurrentProject.getInstance().getKnowledgeBase()).execute();
                    CursorManager.getInstance().setNormalCursor();
                }
                catch (Exception e) {
                    ErrorDialogManager.getInstance().showException(e);
                }
            }
        } else {
            ErrorDialogManager.getInstance().showError("A knowledge base must be loaded.");
        }
    }
}

