/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.wizard.WizardManager;
import scimat.model.knowledgebase.exception.IncorrectFormatKnowledgeBaseException;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class LoadProjectTask
implements NoUndoableTask {
    private JComponent receiver;

    public LoadProjectTask(JComponent component) {
        this.receiver = component;
    }

    public void execute() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showOpenDialog(this.receiver);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                CursorManager.getInstance().setWaitCursor();
                CurrentProject.getInstance().loadProyect(path);
                CursorManager.getInstance().setNormalCursor();
            }
            catch (KnowledgeBaseException e) {
                CursorManager.getInstance().setNormalCursor();
                if (e instanceof IncorrectFormatKnowledgeBaseException) {
                    int val = JOptionPane.showConfirmDialog(this.receiver, "The file contains an old knowledge base format.\nDo you wan to upgrade the knowledge base to the current verion?", "Upgrade", 1, 3);
                    if (val == 0) {
                        WizardManager.getInstance().showUpdgradeKnowledgeBaseDialog(path);
                    }
                }
                ErrorDialogManager.getInstance().showError("The file's format is incorrect.\nAn error happened.\nPlease choose other file.");
            }
        }
    }
}

