/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import scimat.analysis.CurrentAnalysis;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.analysisview.AnalysisViewManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class LoadAnalysisTask
implements NoUndoableTask {
    private JComponent receiver;

    public LoadAnalysisTask(JComponent component) {
        this.receiver = component;
    }

    public void execute() {
        int returnVal;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (CurrentProject.getInstance().isKnowledbaseLoaded()) {
            fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
        }
        if ((returnVal = fileChooser.showOpenDialog(this.receiver)) == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                CursorManager.getInstance().setWaitCursor();
                CurrentAnalysis.getInstance().loadResults(path);
                CursorManager.getInstance().setNormalCursor();
            }
            catch (Exception e) {
                CursorManager.getInstance().setNormalCursor();
                e.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this.receiver, "The file's format is incorrect.\nAn error happened.\nPlease choose other file.", "Error", 0);
            }
            AnalysisViewManager.getInstance().showAnalysisViewDialog();
        }
    }
}

