/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import scimat.api.imports.ImportGroupsXML;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class ImportGroupTask
implements NoUndoableTask {
    private JComponent receiver;

    public ImportGroupTask(JComponent component) {
        this.receiver = component;
    }

    public void execute() {
        JOptionPane.showMessageDialog(this.receiver, "The groups will be modified and this action can not be undone. \nDo you want to continue?", "Continue?", 3);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
        int returnVal = fileChooser.showOpenDialog(this.receiver);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                CursorManager.getInstance().setWaitCursor();
                new ImportGroupsXML(CurrentProject.getInstance().getKnowledgeBase(), path).execute();
                CurrentProject.getInstance().getKbObserver().fireKnowledgeBaseRefresh();
                CursorManager.getInstance().setNormalCursor();
            }
            catch (Exception e) {
                CursorManager.getInstance().setNormalCursor();
                e.printStackTrace(System.err);
                ErrorDialogManager.getInstance().showException(e);
            }
        }
    }
}

