/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import scimat.api.loader.CsvLoader;
import scimat.api.loader.GenericLoader;
import scimat.api.loader.ISIWoSLoader;
import scimat.api.loader.RISLoader;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ChooseCharDelimiterDialog;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class ImportFileTask
implements NoUndoableTask {
    private FormatAvailable format;
    private JFrame receiver;

    public ImportFileTask(FormatAvailable format, JFrame receiver) {
        this.format = format;
        this.receiver = receiver;
    }

    public void execute() {
        GenericLoader loader = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
        int returnVal = fileChooser.showOpenDialog(this.receiver);
        if (returnVal == 0) {
            File[] files = fileChooser.getSelectedFiles();
            returnVal = JOptionPane.showConfirmDialog(this.receiver, "The references may delay the import process. Do you want to import them?", "Import references?", 1, 3);
            if (returnVal != 2) {
                boolean importReferences = returnVal == 0;
                try {
                    CursorManager.getInstance().setWaitCursor();
                    for (int i = 0; i < files.length; ++i) {
                        String path = files[i].getAbsolutePath();
                        System.out.println("Loading file " + path);
                        switch (this.format) {
                            case ISIWoS: {
                                loader = new ISIWoSLoader(path, importReferences);
                                break;
                            }
                            case RIS: {
                                loader = new RISLoader(path, importReferences);
                                break;
                            }
                            case CSV: {
                                ChooseCharDelimiterDialog dialog = new ChooseCharDelimiterDialog((Frame)this.receiver, true);
                                dialog.setVisible(true);
                                loader = new CsvLoader(path, dialog.getCharDelimiter(), importReferences);
                            }
                        }
                        loader.execute(CurrentProject.getInstance().getKnowledgeBase());
                    }
                    CursorManager.getInstance().setNormalCursor();
                }
                catch (Exception e) {
                    CursorManager.getInstance().setNormalCursor();
                    e.printStackTrace(System.err);
                    JOptionPane.showMessageDialog(this.receiver, "The file's format is incorrect.\nAn error happened.\nPlease choose other file.", "Error", 0);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatAvailable {
        ISIWoS,
        RIS,
        CSV;

    }
}

